/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.Sampler;
import se.hirt.greychart.util.ChartRenderingToolkit;

public abstract class AbstractSampler
implements Sampler {
    protected SamplePoint[] samples;
    protected long m_count = 0L;
    protected double m_maxY = Double.NaN;
    protected double m_minY = Double.NaN;
    protected int m_sampleCount = -1;
    protected boolean m_logarithmic = false;

    public AbstractSampler(int size) {
        this.samples = new SamplePoint[size];
        int i = 0;
        while (i < size) {
            this.samples[i] = new SamplePoint();
            this.samples[i].x = i;
            this.samples[i].sampled = false;
            ++i;
        }
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.samples.length) {
            this.samples[i].y = 0.0;
            this.samples[i].count = 0L;
            this.samples[i].sampled = false;
            this.samples[i].min = Double.POSITIVE_INFINITY;
            this.samples[i].max = Double.NEGATIVE_INFINITY;
            this.samples[i].x = i;
            ++i;
        }
        this.m_minY = Double.NaN;
        this.m_maxY = Double.NaN;
        this.m_count = 0L;
        this.m_sampleCount = -1;
    }

    public void setLogarithmic(boolean logarithmic) {
        this.m_logarithmic = logarithmic;
    }

    @Override
    public void addDataPoint(double normalizedX, double currentY) {
        if (normalizedX < 0.0 || normalizedX > 1.0) {
            throw new IllegalArgumentException("Must add a normalized value [0, 1]! Value was " + normalizedX);
        }
        this.addSamplePoint((double)this.samples.length * normalizedX, currentY);
    }

    protected abstract void addSamplePoint(double var1, double var3);

    protected int getIndex(double x) {
        return (int)ChartRenderingToolkit.fastFloor(x);
    }

    @Override
    public SamplePoint[] getSamples() {
        return this.samples;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < this.samples.length) {
            builder.append(String.valueOf(i));
            builder.append("  ");
            builder.append(this.samples[i]);
            builder.append('\n');
            ++i;
        }
        return builder.toString();
    }

    public int getSize() {
        return this.samples.length;
    }

    public long getDataPointCount() {
        return this.m_count;
    }

    public double getMaxY() {
        if (Double.isNaN(this.m_maxY)) {
            this.calcStatistics();
        }
        return this.m_maxY;
    }

    public double getMinY() {
        if (Double.isNaN(this.m_minY)) {
            this.calcStatistics();
        }
        return this.m_minY;
    }

    public int getSampleCount() {
        if (this.m_sampleCount < 0) {
            this.calcStatistics();
        }
        return this.m_sampleCount;
    }

    protected abstract void calcStatistics();
}

