/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.providers.AbstractSampler;

public class SampleCountingBuffer
extends AbstractSampler {
    public SampleCountingBuffer(int size) {
        super(size);
        this.samples = new SamplePoint[size];
        int i = 0;
        while (i < size) {
            this.samples[i] = new SamplePoint();
            this.samples[i].x = i;
            this.samples[i].sampled = true;
            ++i;
        }
    }

    @Override
    public void reset() {
        int i = 0;
        while (i < this.samples.length) {
            this.samples[i].y = 0.0;
            this.samples[i].count = 0L;
            this.samples[i].sampled = true;
            this.samples[i].min = Double.POSITIVE_INFINITY;
            this.samples[i].max = Double.NEGATIVE_INFINITY;
            this.samples[i].x = i;
            ++i;
        }
        this.m_minY = Double.NaN;
        this.m_maxY = Double.NaN;
        this.m_count = 0L;
        this.m_sampleCount = -1;
    }

    @Override
    protected void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            this.samples[currentIndex].y += 1.0;
            this.samples[currentIndex].sampled = true;
            ++this.m_count;
        }
    }

    @Override
    protected void calcStatistics() {
        int n = 0;
        while (n < this.samples.length) {
            if (this.samples[n].hasSample()) {
                if (this.m_logarithmic && this.samples[n].y != 0.0) {
                    this.samples[n].y = Math.log(this.samples[n].y + 3.0);
                }
                if (Double.isNaN(this.m_maxY)) {
                    this.m_maxY = this.samples[n].y;
                    this.m_minY = this.samples[n].y;
                }
                this.m_maxY = Math.max(this.samples[n].y, this.m_maxY);
                this.m_minY = Math.min(this.samples[n].y, this.m_minY);
                this.m_sampleCount = (int)((long)this.m_sampleCount + this.samples[n].count);
            }
            ++n;
        }
    }
}

