/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.providers.AbstractSampler;

public final class StackingBuffer
extends AbstractSampler {
    public StackingBuffer(int size) {
        super(size);
    }

    public void addNonNormalizedDataPoint(double currentX, double currentY) {
        this.addSamplePoint(currentX, currentY);
    }

    @Override
    protected void addSamplePoint(double currentX, double currentY) {
        int currentIndex = this.getIndex(currentX);
        if (currentIndex >= 0 && currentIndex < this.samples.length) {
            ++this.samples[currentIndex].count;
            this.samples[currentIndex].y += currentY;
            this.samples[currentIndex].sampled = true;
            ++this.m_count;
        }
    }

    @Override
    protected void calcStatistics() {
        SamplePoint[] samplePointArray = this.samples;
        int n = this.samples.length;
        int n2 = 0;
        while (n2 < n) {
            SamplePoint sample = samplePointArray[n2];
            if (sample.hasSample()) {
                if (Double.isNaN(this.m_maxY)) {
                    this.m_maxY = sample.y;
                    this.m_minY = sample.y;
                }
                this.m_maxY = Math.max(sample.y, this.m_maxY);
                this.m_minY = Math.min(sample.y, this.m_minY);
                this.m_sampleCount = (int)((long)this.m_sampleCount + sample.count);
            }
            ++n2;
        }
    }
}

