/*
 * Decompiled with CFR 0.152.
 */
package se.hirt.greychart.providers;

import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.impl.CancelService;
import se.hirt.greychart.impl.LongWorldToDeviceConverter;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.WorldToDeviceConverter;
import se.hirt.greychart.providers.IntegratingSubsamplingBuffer;
import se.hirt.greychart.providers.SubsamplingBuffer;

public final class SubsamplingProvider
implements OptimizingProvider {
    private final DataSeries<IXYData> m_dataSeries;
    private final XAxis m_xAxis;
    private SubsamplingBuffer m_sampleBuffer = new SubsamplingBuffer(0);
    private List m_samplesList = new LinkedList();
    private long m_startX;
    private long m_endX;
    private int m_requestedResolution = 0;
    private long m_requestedStartX = Long.MIN_VALUE;
    private long m_requestedEndX = Long.MAX_VALUE;
    private int m_lastWidth;
    private volatile boolean dataChangeOccured = false;
    private final boolean m_integrate;
    private final CancelService m_cancelService;

    public SubsamplingProvider(DataSeries<IXYData> s, XAxis xAxis, CancelService cancelService, boolean integrate) {
        this.m_dataSeries = s;
        this.m_cancelService = cancelService;
        this.m_xAxis = xAxis;
        this.m_integrate = integrate;
        s.addChangeListener(new DataChangeListener(){

            @Override
            public void onDataChange(DataChangeEvent event) {
                SubsamplingProvider.this.dataChangeOccured = true;
            }
        });
    }

    @Override
    public void dispose() {
        this.m_sampleBuffer = null;
    }

    @Override
    public boolean update() {
        if (this.isScheduleResample()) {
            this.scheduleResample(this.m_requestedResolution);
            this.dataChangeOccured = false;
            return true;
        }
        return false;
    }

    private boolean isScheduleResample() {
        return this.hasRangeChanged() || this.hasDataChanged() || this.isSampleBufferInvalid();
    }

    private boolean hasRangeChanged() {
        return this.m_startX != this.m_requestedStartX || this.m_endX != this.m_requestedEndX;
    }

    @Override
    public void setDataChanged(boolean changed) {
        this.dataChangeOccured = changed;
    }

    @Override
    public boolean hasDataChanged() {
        return this.dataChangeOccured;
    }

    private boolean isSampleBufferInvalid() {
        return this.m_sampleBuffer == null || this.m_sampleBuffer.getSize() != this.m_requestedResolution;
    }

    @Override
    public void setResolution(int resolution) {
        this.m_requestedResolution = resolution;
    }

    private void scheduleResample(int resolution) {
        this.m_sampleBuffer = this.createSampleBuffer(resolution);
        this.m_samplesList.clear();
        this.m_startX = this.m_requestedStartX;
        this.m_endX = this.m_requestedEndX;
    }

    public List<SamplePoint> getSamplesList(int width) {
        this.m_samplesList = this.createSampleList(width);
        return this.m_samplesList;
    }

    @Override
    public Polygon getSamplesPolygon(LongWorldToDeviceConverter xWorldToDevice, WorldToDeviceConverter yWorldToDevice) {
        int deviceWidth = xWorldToDevice.getDeviceWidth();
        List<SamplePoint> samplesList = this.getSamplesList(deviceWidth);
        int resultingSamples = this.calculateResultingSamples(samplesList);
        int[] xs = new int[resultingSamples + 3];
        int[] ys = new int[resultingSamples + 3];
        int index = 0;
        if (yWorldToDevice.canCalculateDeviceCoordinate()) {
            Iterator<SamplePoint> it = samplesList.iterator();
            block5: while (it.hasNext() && index < resultingSamples) {
                SamplePoint sp = it.next();
                xs[index] = sp.x;
                switch ((int)sp.count) {
                    case 0: {
                        assert (false);
                        continue block5;
                    }
                    case 1: {
                        ys[index++] = yWorldToDevice.getDeviceCoordinate(sp.y);
                        break;
                    }
                    case 2: {
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.y);
                        xs[++index] = sp.x;
                        ys[index++] = yWorldToDevice.getDeviceCoordinate(sp.yOut);
                        break;
                    }
                    default: {
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.y);
                        xs[++index] = sp.x;
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.min);
                        xs[++index] = sp.x;
                        ys[index] = yWorldToDevice.getDeviceCoordinate(sp.max);
                        xs[++index] = sp.x;
                        ys[index++] = yWorldToDevice.getDeviceCoordinate(sp.yOut);
                    }
                }
            }
        }
        return new Polygon(xs, ys, index);
    }

    private int calculateResultingSamples(List samplesList) {
        int resultCount = 0;
        for (SamplePoint sp : samplesList) {
            resultCount += this.calculateNeededSamples(sp);
        }
        return resultCount;
    }

    private int calculateNeededSamples(SamplePoint sp) {
        switch ((int)sp.count) {
            case 0: {
                assert (false);
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    private List createSampleList(int width) {
        SamplePoint[] points = this.m_sampleBuffer.getSamples();
        ArrayList<SamplePoint> list = new ArrayList<SamplePoint>(this.m_sampleBuffer.getSize());
        SamplePoint[] samplePointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            SamplePoint point = samplePointArray[n2];
            if (point.hasSample()) {
                list.add(point);
            }
            ++n2;
        }
        return list;
    }

    private SubsamplingBuffer createSampleBuffer(int width) {
        SubsamplingBuffer sampleBuffer = null;
        if (this.m_lastWidth == width) {
            sampleBuffer = this.m_sampleBuffer;
            sampleBuffer.reset();
        } else {
            sampleBuffer = this.isIntegrate() ? new IntegratingSubsamplingBuffer(width) : new SubsamplingBuffer(width);
            this.m_lastWidth = width;
        }
        long worldWidth = this.m_xAxis.getMax().longValue() - this.m_xAxis.getMin().longValue();
        long leftEdge = this.m_xAxis.getMin().longValue();
        long rightEdge = leftEdge + worldWidth;
        Iterator<IXYData> it = this.m_dataSeries.createIterator(this.m_requestedStartX, this.m_requestedEndX);
        if (!it.hasNext()) {
            return sampleBuffer;
        }
        IXYData leftMost = null;
        IXYData rightMost = null;
        IXYData rightMostWithin = null;
        IXYData leftMostWithin = null;
        while (it.hasNext() && this.m_cancelService.isNotCancelled()) {
            IXYData newData = it.next();
            long x = this.getXAsLong(newData);
            if (x < leftEdge && (leftMost == null || x >= this.getXAsLong(leftMost))) {
                leftMost = newData;
            } else if (x > rightEdge && (rightMost == null || x < this.getXAsLong(rightMost))) {
                rightMost = newData;
            }
            if (x < leftEdge || x > rightEdge) continue;
            this.addXYDataPoint(sampleBuffer, worldWidth, leftEdge, newData);
            if (leftMostWithin == null) {
                leftMostWithin = newData;
                rightMostWithin = newData;
                continue;
            }
            if (this.getXAsLong(leftMostWithin) > x) {
                leftMostWithin = newData;
                continue;
            }
            if (this.getXAsLong(rightMostWithin) > x) continue;
            rightMostWithin = newData;
        }
        if (this.isIntegrate()) {
            ((IntegratingSubsamplingBuffer)sampleBuffer).fixSamples();
        } else {
            leftMostWithin = leftMostWithin == null ? rightMost : leftMostWithin;
            IXYData iXYData = rightMostWithin = rightMostWithin == null ? leftMost : rightMostWithin;
            if (leftMost != null && leftMostWithin != null && this.getXAsLong(leftMostWithin) != leftEdge && this.getXAsLong(leftMost) < leftEdge) {
                this.addInterpolatedNormalizedPoint(sampleBuffer, 0.0, leftMost, leftMostWithin, worldWidth, leftEdge);
            }
            if (rightMost != null && rightMostWithin != null && this.getXAsLong(rightMostWithin) != rightEdge && this.getXAsLong(rightMost) > rightEdge) {
                this.addInterpolatedNormalizedPoint(sampleBuffer, 1.0, rightMostWithin, rightMost, worldWidth, leftEdge);
            }
        }
        return sampleBuffer;
    }

    private long getXAsLong(IXYData data) {
        return ((Number)data.getX()).longValue();
    }

    private long getYAsLong(IXYData data) {
        return ((Number)data.getY()).longValue();
    }

    private void addInterpolatedNormalizedPoint(SubsamplingBuffer sampleBuffer, double boundary, IXYData beforeData, IXYData afterData, long worldWidth, long leftEdge) {
        assert (!this.isIntegrate());
        double n1 = this.getNormalizedX(beforeData, worldWidth, leftEdge);
        double n2 = this.getNormalizedX(afterData, worldWidth, leftEdge);
        double y1 = this.getY(beforeData);
        double y2 = this.getY(afterData);
        double k = (y2 - y1) / (n2 - n1);
        double yResult = (boundary - n1) * k + y1;
        sampleBuffer.addDataPoint(boundary, yResult);
    }

    private double getY(IXYData data) {
        return ((Number)data.getY()).doubleValue();
    }

    private void addXYDataPoint(SubsamplingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        if (this.isIntegrate()) {
            this.addIntegratedXYDataPoint((IntegratingSubsamplingBuffer)sampleBuffer, worldWidth, leftEdge, data);
        } else {
            this.addNormalXYDataPoint(sampleBuffer, worldWidth, leftEdge, data);
        }
    }

    private void addNormalXYDataPoint(SubsamplingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        double n = this.getNormalizedX(data, worldWidth, leftEdge);
        double y = ((Number)data.getY()).doubleValue();
        sampleBuffer.addDataPoint(n, y);
    }

    private void addIntegratedValue(IntegratingSubsamplingBuffer sampleBuffer, long worldWidth, long leftEdge, long x, long y, long duration) {
        double n = this.getNormalizedX(x, worldWidth, leftEdge);
        double n2 = this.getNormalizedX(Math.min(leftEdge + worldWidth, x + duration), worldWidth, leftEdge);
        sampleBuffer.addDataPoint(n, n2, y);
    }

    private void addIntegratedXYDataPoint(IntegratingSubsamplingBuffer sampleBuffer, long worldWidth, long leftEdge, IXYData data) {
        this.addIntegratedValue(sampleBuffer, worldWidth, leftEdge, this.getXAsLong(data), this.getYAsLong(data), this.getYAsLong(data));
    }

    private double getNormalizedX(IXYData data, long worldWidth, long leftEdge) {
        return (double)(this.getXAsLong(data) - leftEdge) / (double)worldWidth;
    }

    private double getNormalizedX(long x, long worldWidth, long leftEdge) {
        return (double)(x - leftEdge) / (double)worldWidth;
    }

    @Override
    public DataSeries getDataSeries() {
        return this.m_dataSeries;
    }

    @Override
    public OptimizingProvider[] getChildren() {
        return new OptimizingProvider[0];
    }

    @Override
    public synchronized long getMaxX() {
        return this.m_endX;
    }

    @Override
    public synchronized long getMinX() {
        return this.m_startX;
    }

    @Override
    public double getMaxY() {
        return this.m_sampleBuffer.getMaxY();
    }

    @Override
    public double getMinY() {
        return this.m_sampleBuffer.getMinY();
    }

    @Override
    public synchronized void setRange(long start, long end) {
        this.m_requestedStartX = start;
        this.m_requestedEndX = end;
        this.update();
    }

    @Override
    public long getValueCount() {
        return this.m_sampleBuffer.getDataPointCount();
    }

    @Override
    public Iterator<SamplePoint> getSamples(int width) {
        return this.getSamplesList(width).iterator();
    }

    private boolean isIntegrate() {
        return this.m_integrate;
    }
}

