/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;

final class ArrayParser
implements IParser {
    private final IParser m_elementType;

    ArrayParser(IParser elementType) {
        this.m_elementType = elementType;
    }

    public Object[] read(byte[] data, Offset offset) {
        int arraySize = IntegerParser.readInt(data, offset);
        Object[] array = new Object[arraySize];
        int n = 0;
        while (n < arraySize) {
            array[n] = this.m_elementType.read(data, offset);
            ++n;
        }
        return array;
    }

    @Override
    public Object read(byte[] data, int offset) {
        int arraySize = IntegerParser.readInt(data, offset);
        Object[] array = new Object[arraySize];
        int n = 0;
        while (n < arraySize) {
            array[n] = this.m_elementType.read(data, offset);
            offset += this.m_elementType.sizeOfObjectAt(data, offset);
            ++n;
        }
        return array;
    }

    @Override
    public int sizeOfObjectAt(byte[] data, int offset) {
        int arraySize = IntegerParser.readInt(data, offset);
        int objectSize = 4;
        int n = 0;
        while (n < arraySize) {
            objectSize += this.m_elementType.sizeOfObjectAt(data, offset + objectSize);
            ++n;
        }
        return objectSize;
    }
}

