/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.ConstantEntryList;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.IPoolFactory;
import java.util.HashMap;
import java.util.Map;

class ConstantMap {
    private Map<Key, ConstantEntryList> map = new HashMap<Key, ConstantEntryList>(17, 0.5f);
    private boolean loadDone;
    private final IPoolFactory factory;
    private Key lookupKey = new Key(0L);

    ConstantMap(IPoolFactory factory) {
        this.factory = factory;
    }

    void setLoadDone() {
        this.loadDone = true;
        for (ConstantEntryList entries : this.map.values()) {
            entries.sort();
        }
    }

    void touchAll() {
        for (Map.Entry<Key, ConstantEntryList> list : this.map.entrySet()) {
            list.getValue().touchAll(list.getKey().value);
        }
    }

    void put(long valueId, Object value, long timestamp) {
        ConstantEntryList entries = this.getEntryList(valueId);
        if (entries == null) {
            entries = new ConstantEntryList(value, timestamp, this.factory);
            this.map.put(new Key(valueId), entries);
        } else {
            entries.add(value, timestamp);
        }
    }

    Object get(long valueId, long atTimestamp) {
        if (this.loadDone) {
            ConstantEntryList entryList = this.getEntryList(valueId);
            if (entryList != null) {
                return entryList.getFirstObjectAfter(valueId, atTimestamp);
            }
            if (this.factory != null) {
                return this.factory.createObject(valueId, null);
            }
            return null;
        }
        return new Reference(valueId);
    }

    private ConstantEntryList getEntryList(long valueId) {
        this.lookupKey.value = valueId;
        return this.map.get(this.lookupKey);
    }

    static Object resolve(Object o, long atTimestamp) {
        if (o instanceof Reference) {
            return ConstantMap.resolve(((Reference)o).resolve(atTimestamp), atTimestamp);
        }
        if (o != null && o.getClass().isArray()) {
            Object[] array = (Object[])o;
            int n = 0;
            while (n < array.length) {
                array[n] = ConstantMap.resolve(array[n], atTimestamp);
                ++n;
            }
            return array;
        }
        return o;
    }

    private static final class Key {
        long value;

        Key(long value) {
            this.value = value;
        }

        public int hashCode() {
            return (int)(this.value ^ this.value >>> 32);
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                return ((Key)object).value == this.value;
            }
            return false;
        }

        public String toString() {
            return Long.toString(this.value);
        }
    }

    private class Reference {
        private long id;

        Reference(long id) {
            this.id = id;
        }

        Object resolve(long atTimestamp) {
            return ConstantMap.this.get(this.id, atTimestamp);
        }
    }
}

