/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.DataTypeParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Synthetics;
import com.jrockit.mc.flightrecorder.internal.parser.binary.TransitionParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.UTFStringParser;
import com.jrockit.mc.flightrecorder.internal.parser.model.DataStructure;
import com.jrockit.mc.flightrecorder.internal.parser.model.DataType;
import com.jrockit.mc.flightrecorder.internal.parser.model.Transition;
import com.jrockit.mc.flightrecorder.internal.parser.model.ValueDescriptor;

final class DataStructureParser {
    private final UTFStringParser IDENTIFIER = new UTFStringParser();
    private final UTFStringParser NAME = new UTFStringParser();
    private final UTFStringParser DESCRIPTION = new UTFStringParser();
    private final DataTypeParser DATATYPE = new DataTypeParser();
    private final TransitionParser TRANSITION = new TransitionParser();
    private String[] relations;

    DataStructureParser(String[] relations) {
        this.relations = relations;
    }

    public DataStructure[] read(byte[] data, Offset offset) {
        int noDataStructures = IntegerParser.readInt(data, offset);
        DataStructure[] dataStructures = new DataStructure[noDataStructures];
        int i = 0;
        while (i < noDataStructures) {
            int arraySize = IntegerParser.readInt(data, offset);
            ValueDescriptor[] vds = new ValueDescriptor[arraySize];
            int n = 0;
            while (n < arraySize) {
                String id = this.IDENTIFIER.read(data, offset);
                String name = this.NAME.read(data, offset);
                String description = this.DESCRIPTION.read(data, offset);
                Transition transition = this.TRANSITION.read(data, offset);
                DataType dataType = this.DATATYPE.read(data, offset);
                int contentType = IntegerParser.readInt(data, offset);
                int dataStructureIndex = IntegerParser.readInt(data, offset);
                offset.increase(4);
                String contentTypeString = Synthetics.createContentTypeString(contentType, dataType);
                int relationsIndex = Synthetics.deduceRelationIndex(dataType, dataStructureIndex);
                String relation = null;
                if (relationsIndex >= 0) {
                    relation = this.relations[relationsIndex];
                }
                vds[n] = new ValueDescriptor(id, name, description, transition, dataType, contentTypeString, relation, contentType, dataStructures, dataStructureIndex);
                ++n;
            }
            dataStructures[i] = new DataStructure(vds);
            ++i;
        }
        return dataStructures;
    }
}

