/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.model.FLRThread;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Chunk;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ChunkMetadata;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ConstantPool;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventCollection;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventParserBuilder;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.LongParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ParserFactory;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Synthetics;
import com.jrockit.mc.flightrecorder.internal.parser.binary.factories.GlobalObjectPool;
import com.jrockit.mc.flightrecorder.internal.parser.model.ContentType;
import com.jrockit.mc.flightrecorder.internal.parser.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.parser.model.ProducerDescriptor;
import com.jrockit.mc.flightrecorder.provider.FastAccessNumberMap;
import com.jrockit.mc.flightrecorder.provider.Producer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class EventParserManager {
    private FastAccessNumberMap<EventParser> eventParsers = new FastAccessNumberMap(100);
    private Map<Integer, ConstantPool> constantPools = new HashMap<Integer, ConstantPool>();
    private ChunkMetadata metadata;
    private long rangeStart = Long.MAX_VALUE;
    private long rangeEnd = 0L;
    private long currentEventTimestamp;
    private ConstantPool.IPoolUser poolUser = new ConstantPool.IPoolUser(){

        @Override
        public long getCurrentEventTimestamp() {
            return EventParserManager.this.currentEventTimestamp;
        }
    };

    public EventParserManager(ChunkMetadata metadata, byte[] chunkData, GlobalObjectPool globalObjects) {
        int n;
        ProducerDescriptor pd;
        this.metadata = metadata;
        ParserFactory parserFactory = new ParserFactory(this.constantPools, metadata.getTicsPerNano());
        ProducerDescriptor[] producerDescriptorArray = metadata.getProducers();
        int n2 = producerDescriptorArray.length;
        int n3 = 0;
        while (n3 < n2) {
            pd = producerDescriptorArray[n3];
            ContentType[] contentTypeArray = pd.getContentTypes();
            n = contentTypeArray.length;
            int n4 = 0;
            while (n4 < n) {
                ContentType ct = contentTypeArray[n4];
                ConstantPool pool = new ConstantPool(parserFactory, globalObjects.getFactory(ct), this.poolUser, ct);
                this.constantPools.put(ct.getContentTypeId(), pool);
                ++n4;
            }
            ++n3;
        }
        this.parseCheckPoints(chunkData, metadata.getPreviousCheckPoint());
        for (ConstantPool pool : this.constantPools.values()) {
            pool.setLoadDone();
        }
        producerDescriptorArray = metadata.getProducers();
        n2 = producerDescriptorArray.length;
        int n5 = 0;
        while (n5 < n2) {
            pd = producerDescriptorArray[n5];
            Producer producer = globalObjects.createProducer(pd);
            EventTypeDescriptor[] eventTypeDescriptorArray = pd.getEventTypeDescriptors();
            int n6 = eventTypeDescriptorArray.length;
            n = 0;
            while (n < n6) {
                EventTypeDescriptor etd = eventTypeDescriptorArray[n];
                EventParser eventParser = EventParserBuilder.createEventParser(etd, producer, parserFactory);
                this.eventParsers.put(eventParser.getEventType().getId(), eventParser);
                ++n;
            }
            if (producer.getId() == 1) {
                EventTypeDescriptor bufferLost = Synthetics.getBufferLostEventType();
                EventParser eventParser = EventParserBuilder.createEventParser(bufferLost, producer, parserFactory);
                this.eventParsers.put(eventParser.getEventType().getId(), eventParser);
            }
            ++n5;
        }
        ConstantPool threadPool = this.constantPools.get(8);
        if (threadPool != null) {
            threadPool.touchAll();
        }
    }

    public void loadEvent(byte[] data, Offset offset, int eventTypeId) {
        EventParser ep = this.eventParsers.get(eventTypeId);
        if (ep == null) {
            throw new IllegalArgumentException("Event type " + eventTypeId + " is not described in the file");
        }
        this.currentEventTimestamp = this.metadata.asNanoTimestame(LongParser.readLong(data, offset));
        long startTime = ep.getEventType().hasStartTime() ? this.metadata.asNanoTimestame(LongParser.readLong(data, offset)) : this.currentEventTimestamp;
        ep.loadEvent(data, offset, startTime, this.currentEventTimestamp);
        this.rangeStart = Math.min(this.rangeStart, startTime);
        this.rangeEnd = Math.max(this.rangeEnd, this.currentEventTimestamp);
    }

    public Iterable<Chunk.EventEntry> getEvents() {
        ArrayList<Chunk.EventEntry> allEvents = new ArrayList<Chunk.EventEntry>();
        for (EventParser ep : this.eventParsers) {
            if (ep == null) continue;
            for (Map.Entry<FLRThread, EventCollection> entry : ep.getLoadedEvents()) {
                allEvents.add(new Chunk.EventEntry(entry.getKey(), ep.getEventType(), entry.getValue()));
            }
        }
        return allEvents;
    }

    private void parseCheckPoints(byte[] data, int prevCpOffset) {
        while (prevCpOffset != 0) {
            Offset offset = new Offset(prevCpOffset);
            int end = offset.get();
            int checkPointSize = IntegerParser.readInt(data, offset);
            end += checkPointSize;
            offset.increase(4);
            long timestamp = this.metadata.asNanoTimestame(LongParser.readLong(data, offset));
            prevCpOffset = (int)LongParser.readLong(data, offset);
            while (offset.get() < end) {
                int contentTypeId = IntegerParser.readInt(data, offset);
                ConstantPool pool = this.constantPools.get(contentTypeId);
                int entries = IntegerParser.readInt(data, offset);
                int n = 0;
                while (n < entries) {
                    pool.insertValue(data, offset, timestamp);
                    ++n;
                }
            }
        }
    }

    public long getStartTime() {
        return this.rangeStart;
    }

    public long getEndTime() {
        return this.rangeEnd;
    }
}

