/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.BooleanParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ITypedParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.internal.parser.binary.UTFStringParser;
import com.jrockit.mc.flightrecorder.internal.parser.model.DataStructure;
import com.jrockit.mc.flightrecorder.internal.parser.model.EventTypeDescriptor;

final class EventTypeParser
implements ITypedParser<EventTypeDescriptor> {
    private final UTFStringParser NAME = new UTFStringParser();
    private final UTFStringParser DESCRIPTION = new UTFStringParser();
    private final UTFStringParser PATH = new UTFStringParser();
    private DataStructure[] dataStructures;

    public EventTypeParser(DataStructure[] dataStructures) {
        this.dataStructures = dataStructures;
    }

    @Override
    public EventTypeDescriptor read(byte[] data, Offset offset) {
        int id = IntegerParser.readInt(data, offset);
        String name = this.NAME.read(data, offset);
        String description = this.DESCRIPTION.read(data, offset);
        String path = this.PATH.read(data, offset);
        boolean hasStartTime = BooleanParser.readBoolean(data, offset);
        boolean hasThread = BooleanParser.readBoolean(data, offset);
        boolean canHaveStacktrace = BooleanParser.readBoolean(data, offset);
        boolean isRequestable = BooleanParser.readBoolean(data, offset);
        int structIndex = IntegerParser.readInt(data, offset);
        offset.increase(4);
        return new EventTypeDescriptor(id, name, hasStartTime, hasThread, canHaveStacktrace, isRequestable, this.dataStructures[structIndex].getValueDescriptors(), description, path);
    }

    public EventTypeDescriptor[] createArray(int length) {
        return new EventTypeDescriptor[length];
    }
}

