/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;

public final class IntegerParser
implements IParser {
    public static final int SIZE = 4;
    public static final IntegerParser INSTANCE = new IntegerParser();
    private Integer cache = 0;

    @Override
    public Integer read(byte[] data, Offset offset) {
        int index = offset.get();
        offset.increase(4);
        return this.read(data, index);
    }

    @Override
    public Integer read(byte[] data, int offset) {
        Integer localInteger;
        int l = IntegerParser.readInt(data, offset);
        if (l == (localInteger = this.cache)) {
            return localInteger;
        }
        this.cache = localInteger = Integer.valueOf(l);
        return localInteger;
    }

    @Override
    public int sizeOfObjectAt(byte[] data, int offset) {
        return 4;
    }

    public static int readInt(byte[] bytes, Offset offset) {
        int index = offset.get();
        offset.increase(4);
        return IntegerParser.readInt(bytes, index);
    }

    public static int readInt(byte[] bytes, int index) {
        int ch1 = bytes[index] & 0xFF;
        int ch2 = bytes[index + 1] & 0xFF;
        int ch3 = bytes[index + 2] & 0xFF;
        int ch4 = bytes[index + 3] & 0xFF;
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }
}

