/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;

public final class LongParser
implements IParser {
    public static final int SIZE = 8;
    public static final LongParser INSTANCE = new LongParser();
    private Long cache = 0L;

    @Override
    public Long read(byte[] data, Offset offset) {
        int index = offset.get();
        offset.increase(8);
        return this.read(data, index);
    }

    @Override
    public Long read(byte[] bytes, int offset) {
        Long localLong;
        long l = LongParser.readLong(bytes, offset);
        if (l == (localLong = this.cache)) {
            return localLong;
        }
        this.cache = localLong = Long.valueOf(l);
        return localLong;
    }

    public static long readLong(byte[] bytes, Offset offset) {
        int index = offset.get();
        offset.increase(8);
        return LongParser.readLong(bytes, index);
    }

    public static long readLong(byte[] bytes, int index) {
        return ((long)bytes[index + 0] << 56) + ((long)(bytes[index + 1] & 0xFF) << 48) + ((long)(bytes[index + 2] & 0xFF) << 40) + ((long)(bytes[index + 3] & 0xFF) << 32) + ((long)(bytes[index + 4] & 0xFF) << 24) + (long)((bytes[index + 5] & 0xFF) << 16) + (long)((bytes[index + 6] & 0xFF) << 8) + (long)((bytes[index + 7] & 0xFF) << 0);
    }

    @Override
    public int sizeOfObjectAt(byte[] data, int offset) {
        return 8;
    }
}

