/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.ContentTypeParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.DataStructureParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.EventTypeParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ITypedParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import com.jrockit.mc.flightrecorder.internal.parser.binary.TypedArrayParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.UTFStringParser;
import com.jrockit.mc.flightrecorder.internal.parser.model.ContentType;
import com.jrockit.mc.flightrecorder.internal.parser.model.DataStructure;
import com.jrockit.mc.flightrecorder.internal.parser.model.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.internal.parser.model.ProducerDescriptor;

final class ProducerParser
implements ITypedParser<ProducerDescriptor> {
    private static final TypedArrayParser<String> RELATIONS_PARSER = new TypedArrayParser<String>(UTFStringParser.INSTANCE);

    ProducerParser() {
    }

    @Override
    public ProducerDescriptor read(byte[] data, Offset offset) {
        int id = IntegerParser.readInt(data, offset);
        String name = UTFStringParser.INSTANCE.read(data, offset);
        String desc = UTFStringParser.INSTANCE.read(data, offset);
        String uri = UTFStringParser.INSTANCE.read(data, offset);
        String[] relations = RELATIONS_PARSER.read(data, offset);
        DataStructureParser dataStructureParser = new DataStructureParser(relations);
        DataStructure[] dataStructures = dataStructureParser.read(data, offset);
        TypedArrayParser<EventTypeDescriptor> eventTypeParser = new TypedArrayParser<EventTypeDescriptor>(new EventTypeParser(dataStructures));
        EventTypeDescriptor[] eventTypes = eventTypeParser.read(data, offset);
        TypedArrayParser<ContentType> contentTypeParser = new TypedArrayParser<ContentType>(new ContentTypeParser(dataStructures));
        ContentType[] contentTypes = contentTypeParser.read(data, offset);
        return new ProducerDescriptor(name, desc, uri, id, eventTypes, contentTypes);
    }

    public ProducerDescriptor[] createArray(int length) {
        return new ProducerDescriptor[length];
    }
}

