/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IByteInput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RandomAccessFileInput
implements IByteInput {
    private byte[] buffer;
    private RandomAccessFile raf;

    public RandomAccessFileInput(RandomAccessFile raf, int initSize) {
        this.raf = raf;
        this.buffer = new byte[initSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(long position, int length) throws IOException {
        if (this.buffer == null || length > this.buffer.length) {
            this.buffer = new byte[length];
        }
        RandomAccessFile randomAccessFile = this.raf;
        synchronized (randomAccessFile) {
            this.raf.seek(position);
            this.raf.readFully(this.buffer, 0, length);
            return this.buffer;
        }
    }
}

