/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.IntegerParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import java.io.UnsupportedEncodingException;

final class StringParser
implements IParser {
    public static final StringParser INSTANCE = new StringParser();
    private static final String CHARSET = "UTF-16";

    StringParser() {
    }

    @Override
    public Object read(byte[] data, Offset offset) {
        int length = IntegerParser.readInt(data, offset) * 2;
        int index = offset.get();
        offset.increase(length);
        try {
            return new String(data, index, length, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Object read(byte[] data, int offset) {
        int length = IntegerParser.readInt(data, offset) * 2;
        try {
            return new String(data, offset + 4, length, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int sizeOfObjectAt(byte[] data, int offset) {
        int length = IntegerParser.readInt(data, offset) * 2;
        return 4 + length;
    }
}

