/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.internal.parser.binary;

import com.jrockit.mc.flightrecorder.internal.parser.binary.IParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.ITypedParser;
import com.jrockit.mc.flightrecorder.internal.parser.binary.Offset;
import java.io.UnsupportedEncodingException;

final class UTFStringParser
implements IParser,
ITypedParser<String> {
    private static final String CHARSET = "UTF-8";
    public static final UTFStringParser INSTANCE = new UTFStringParser();

    UTFStringParser() {
    }

    @Override
    public String read(byte[] bytes, Offset offset) {
        int len = UTFStringParser.readUnsignedShort(bytes, offset.get());
        offset.increase(2);
        int index = offset.get();
        offset.increase(len);
        try {
            return new String(bytes, index, len, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static int readUnsignedShort(byte[] bytes, int offset) {
        int ch1 = bytes[offset] & 0xFF;
        int ch2 = bytes[offset + 1] & 0xFF;
        return (ch1 << 8) + (ch2 << 0);
    }

    @Override
    public String read(byte[] bytes, int offset) {
        int len = UTFStringParser.readUnsignedShort(bytes, offset);
        try {
            return new String(bytes, offset + 2, len, CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int sizeOfObjectAt(byte[] data, int offset) {
        int len = UTFStringParser.readUnsignedShort(data, offset);
        return 2 + len;
    }

    public String[] createArray(int length) {
        return new String[length];
    }
}

