/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.spi.Expansion;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventFilter;
import com.jrockit.mc.flightrecorder.util.AlwaysTrueFilter;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class RangeIterator
implements Iterator<IEvent> {
    private final IEvent[] events;
    private final IEventFilter filter;
    private int index;
    private int firstIndexOutsideRange;
    private int eventsAfterRange;

    RangeIterator(IEvent[] events, IEventFilter filter, Expansion expansion, long startTime, long endTime) {
        this.events = events;
        this.filter = filter == AlwaysTrueFilter.getInstance() ? null : filter;
        this.eventsAfterRange = expansion.getEndIndexDelta();
        this.index = this.binarySearch(startTime, true);
        this.firstIndexOutsideRange = this.binarySearch(endTime, false);
        int i = 0;
        while (this.index > 0 && i > expansion.getStartIndexDelta()) {
            while (--this.index > 0 && filter != null && !filter.accept(events[this.index])) {
            }
            --i;
        }
    }

    @Override
    public IEvent next() {
        if (this.hasNext()) {
            if (this.index >= this.firstIndexOutsideRange) {
                --this.eventsAfterRange;
            }
            return this.events[this.index++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.firstIndexOutsideRange || this.eventsAfterRange > 0 && this.index < this.events.length) {
            if (this.filter == null || this.filter.accept(this.events[this.index])) {
                return true;
            }
            ++this.index;
        }
        return false;
    }

    private int binarySearch(long boundaryTimestamp, boolean useEndTimestamp) {
        int low = 0;
        int high = this.events.length - 1;
        while (low <= high) {
            long eventTimestamp;
            int middle = low + high >>> 1;
            long l = eventTimestamp = useEndTimestamp ? this.events[middle].getEndTimestamp() : this.events[middle].getStartTimestamp();
            if (eventTimestamp == boundaryTimestamp) {
                return middle;
            }
            if (eventTimestamp < boundaryTimestamp) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return low;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove events from range.");
    }
}

