/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.provider;

import com.jrockit.mc.flightrecorder.provider.Track;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.ITrack;
import com.jrockit.mc.flightrecorder.spi.ITrackGroup;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrackGroup
implements ITrackGroup {
    private final Map<String, TrackGroup> trackGroups = new HashMap<String, TrackGroup>();
    private final Map<String, Track> tracks = new HashMap<String, Track>();
    private String m_name;
    private String m_identifier;
    private final Map<String, Object> m_properties = new HashMap<String, Object>();
    private ITimeRange m_range = TimeRange.INFINITE_RANGE;
    private final TrackGroup m_parent;

    public TrackGroup(TrackGroup parent, String identifier) {
        this.m_parent = parent;
        this.m_identifier = identifier;
        this.m_name = identifier;
    }

    @Override
    public ITrackGroup getParent() {
        return this.m_parent;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public Collection<? extends ITrackGroup> getGroups() {
        return this.trackGroups.values();
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public Collection<? extends ITrack> getTracks() {
        return this.tracks.values();
    }

    @Override
    public Collection<ITrack> getAllTracks() {
        ArrayList<ITrack> allChildren = new ArrayList<ITrack>();
        for (ITrackGroup iTrackGroup : this.getGroups()) {
            allChildren.addAll(iTrackGroup.getAllTracks());
        }
        allChildren.addAll(this.getTracks());
        return allChildren;
    }

    @Override
    public String getIdentifier() {
        return this.m_identifier;
    }

    public TrackGroup getSubGroup(String identifier) {
        TrackGroup trackGroup = this.trackGroups.get(identifier);
        if (trackGroup == null) {
            trackGroup = new TrackGroup(this, identifier);
            this.trackGroups.put(identifier, trackGroup);
        }
        return trackGroup;
    }

    public Track getTrack(String name) {
        Track track = this.tracks.get(name);
        if (track == null) {
            track = new Track(name);
            this.tracks.put(name, track);
        }
        return track;
    }

    @Override
    public ITrackGroup getGroup(String identifier) {
        return this.trackGroups.get(identifier);
    }

    @Override
    public Object getProperty(String key) {
        return this.m_properties.get(key);
    }

    @Override
    public List<ITrackGroup> getAllGroups() {
        ArrayList<ITrackGroup> children = new ArrayList<ITrackGroup>();
        children.addAll(this.getSubGroups());
        return children;
    }

    private List<TrackGroup> getSubGroups() {
        ArrayList<TrackGroup> children = new ArrayList<TrackGroup>();
        for (TrackGroup g : this.trackGroups.values()) {
            children.add(g);
            children.addAll(g.getSubGroups());
        }
        return children;
    }

    public void setProperty(String key, Object value) {
        this.m_properties.put(key, value);
    }

    @Override
    public ITimeRange getRange() {
        return this.m_range;
    }

    public void setRange(ITimeRange range) {
        this.m_range = range;
    }

    @Override
    public String getPath() {
        String path = this.getIdentifier();
        ITrackGroup parent = this.getParent();
        if (parent != null) {
            return String.valueOf(parent.getPath()) + "/" + path;
        }
        return path;
    }
}

