/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.util;

import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import java.util.ArrayList;
import java.util.Arrays;

public class DisjointBuilder<T extends ITimeRange> {
    private int noLanes = 1;
    private DisjointArray<T>[] lanes = new DisjointArray[]{new DisjointArray()};

    public void add(T e) {
        if (!this.lanes[0].accept(e)) {
            int changedLane = this.addToOtherLane(e);
            this.sortLanes(changedLane);
        }
    }

    private void sortLanes(int fromIndex) {
        int i = fromIndex;
        while (i > 0) {
            if (this.lanes[i].getEndTimestamp() > this.lanes[i - 1].getEndTimestamp()) {
                DisjointArray<T> tmp = this.lanes[i - 1];
                this.lanes[i - 1] = this.lanes[i];
                this.lanes[i] = tmp;
            }
            --i;
        }
    }

    private int addToOtherLane(T e) {
        int i = 1;
        while (i < this.noLanes) {
            if (this.lanes[i].accept(e)) {
                return i;
            }
            ++i;
        }
        return this.addToNewLane(e);
    }

    private int addToNewLane(T e) {
        if (this.noLanes >= this.lanes.length) {
            this.lanes = Arrays.copyOf(this.lanes, this.lanes.length * 3 / 2 + 2);
        }
        this.lanes[this.noLanes] = new DisjointArray();
        this.lanes[this.noLanes].accept(e);
        return this.noLanes++;
    }

    public static <U extends ITimeRange> Iterable<U[]> toArrays(Iterable<? extends DisjointBuilder<U>> collections, ArrayFactory<U> arrayFactory) {
        DisjointBuilder merger = new DisjointBuilder();
        for (DisjointBuilder<U> c : collections) {
            int i = 0;
            while (i < c.noLanes) {
                merger.add(c.lanes[i]);
                ++i;
            }
        }
        ArrayList<U[]> result = new ArrayList<U[]>(merger.lanes.length);
        int i = 0;
        while (i < merger.noLanes) {
            DisjointArray lane = merger.lanes[i];
            int size = 0;
            int j = 0;
            while (j < lane.size) {
                size += ((DisjointArray)lane.array[j]).size;
                ++j;
            }
            ITimeRange[] resultArray = (ITimeRange[])arrayFactory.createArray(size);
            int offset = 0;
            int j2 = 0;
            while (j2 < lane.size) {
                DisjointArray innerLane = (DisjointArray)lane.array[j2];
                System.arraycopy(innerLane.array, 0, resultArray, offset, innerLane.size);
                offset += innerLane.size;
                ++j2;
            }
            result.add(resultArray);
            ++i;
        }
        return result;
    }

    public static interface ArrayFactory<U> {
        public U[] createArray(int var1);
    }

    private static class DisjointArray<T extends ITimeRange>
    implements ITimeRange {
        Object[] array = new Object[3];
        int size = 0;

        private DisjointArray() {
        }

        boolean accept(T e) {
            if (this.size >= this.array.length) {
                int newCapacity = this.array.length < 100 ? this.array.length * 4 : this.array.length * 3 / 2 + 1;
                this.array = Arrays.copyOf(this.array, newCapacity);
            }
            if (e.getStartTimestamp() >= this.getEndTimestamp()) {
                this.array[this.size++] = e;
                return true;
            }
            return false;
        }

        @Override
        public long getStartTimestamp() {
            return this.size == 0 ? 0L : ((ITimeRange)this.array[0]).getStartTimestamp();
        }

        @Override
        public long getEndTimestamp() {
            return this.size == 0 ? 0L : ((ITimeRange)this.array[this.size - 1]).getEndTimestamp();
        }

        @Override
        public long getDuration() {
            return this.getEndTimestamp() - this.getStartTimestamp();
        }
    }
}

