/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.util;

import com.jrockit.mc.flightrecorder.util.IPriorityProvider;
import java.util.Iterator;
import java.util.List;

public final class PriorityIterator<Type>
implements Iterator<Type> {
    private final HeapItem<Type>[] m_items;
    private int count = 0;

    public PriorityIterator(List<Iterator<Type>> iterators, List<IPriorityProvider<Type>> provider) {
        this.m_items = new HeapItem[iterators.size() + 1];
        int n = 0;
        while (n < iterators.size()) {
            this.insert(iterators.get(n), provider.get(n));
            ++n;
        }
    }

    public PriorityIterator(List<Iterator<Type>> iterators, IPriorityProvider<Type> provider) {
        this.m_items = new HeapItem[iterators.size() + 1];
        int n = 0;
        while (n < iterators.size()) {
            this.insert(iterators.get(n), provider);
            ++n;
        }
    }

    private static void swap(Object[] array, int i, int j) {
        Object tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.count > 0;
    }

    @Override
    public Type next() {
        HeapItem<Type> item = this.m_items[1];
        Iterator it = ((HeapItem)item).iterator;
        Object result = ((HeapItem)item).value;
        if (it.hasNext()) {
            ((HeapItem)item).value = it.next();
            ((HeapItem)item).priority = ((HeapItem)item).provider.getPriority(((HeapItem)item).value);
            this.moveDown(1);
        } else {
            this.removeTop();
        }
        return (Type)result;
    }

    private void removeTop() {
        PriorityIterator.swap(this.m_items, 1, this.count);
        --this.count;
        this.moveDown(1);
    }

    private void insert(Iterator<Type> it, IPriorityProvider<Type> provider) {
        if (it.hasNext()) {
            ++this.count;
            HeapItem<Type> item = new HeapItem<Type>(it, provider);
            ((HeapItem)item).value = it.next();
            ((HeapItem)item).priority = provider.getPriority(((HeapItem)item).value);
            this.m_items[this.count] = item;
            this.moveUp(this.count);
        }
    }

    private void moveUp(int i) {
        if (i > 1 && ((HeapItem)this.m_items[i]).priority < ((HeapItem)this.m_items[i / 2]).priority) {
            PriorityIterator.swap(this.m_items, i, i / 2);
            this.moveUp(i / 2);
        }
    }

    private void moveDown(int i) {
        int child = 2 * i;
        if (child < this.count && ((HeapItem)this.m_items[child + 1]).priority < ((HeapItem)this.m_items[child]).priority) {
            ++child;
        }
        if (child <= this.count && ((HeapItem)this.m_items[i]).priority > ((HeapItem)this.m_items[child]).priority) {
            PriorityIterator.swap(this.m_items, i, child);
            this.moveDown(child);
        }
    }

    private static final class HeapItem<Type> {
        private final Iterator<Type> iterator;
        private final IPriorityProvider<Type> provider;
        private long priority;
        private Type value;

        HeapItem(Iterator<Type> iterator, IPriorityProvider<Type> provider) {
            this.iterator = iterator;
            this.provider = provider;
        }
    }
}

