/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.mbeanbrowser.attributes.IndexAttributeChild;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.ReadOnlyIndexedAttributeChild;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.ReadOnlyKeyedAttributeChild;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.IAttribute;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.util.internal.PartitionedList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public final class AttributeChildToolkit {
    private AttributeChildToolkit() {
    }

    public static Collection<?> getChildren(IReadOnlyAttribute attribute) {
        Object value = attribute.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.getClass().isArray()) {
            return AttributeChildToolkit.getArrayChildren(attribute, value);
        }
        if (value instanceof CompositeData) {
            return AttributeChildToolkit.getCompositeChildren(attribute, (CompositeData)value);
        }
        if (value instanceof TabularData) {
            return AttributeChildToolkit.getTabularChildren(attribute, (TabularData)value);
        }
        if (value instanceof Collection) {
            return AttributeChildToolkit.getCollectionChildren(attribute, (Collection)value);
        }
        if (value instanceof Map) {
            return AttributeChildToolkit.getMapChildren(attribute, (Map)value);
        }
        return Collections.emptyList();
    }

    private static Collection<?> getArrayChildren(IReadOnlyAttribute parent, Object arrayValue) {
        int length = Array.getLength(arrayValue);
        ArrayList<IReadOnlyAttribute> elements = new ArrayList<IReadOnlyAttribute>(length);
        int i = 0;
        while (i < length) {
            elements.add(AttributeChildToolkit.creatArrayChild(parent, i));
            ++i;
        }
        return PartitionedList.create(elements);
    }

    private static IReadOnlyAttribute creatArrayChild(IReadOnlyAttribute parent, int index) {
        if (parent instanceof IAttribute) {
            return new IndexAttributeChild(parent, index);
        }
        return new ReadOnlyIndexedAttributeChild(parent, index);
    }

    private static Collection<?> getCompositeChildren(IReadOnlyAttribute parent, CompositeData compositeDataValue) {
        if (parent instanceof ReadOnlyMRIAttribute) {
            return AttributeChildToolkit.getMRICompositeChildren((ReadOnlyMRIAttribute)parent, compositeDataValue);
        }
        ArrayList<ReadOnlyKeyedAttributeChild> elements = new ArrayList<ReadOnlyKeyedAttributeChild>();
        for (String key : compositeDataValue.getCompositeType().keySet()) {
            Object childValue = compositeDataValue.get(key);
            elements.add(new ReadOnlyKeyedAttributeChild(parent, String.valueOf('#') + key, childValue));
        }
        return PartitionedList.create(elements);
    }

    private static Collection<?> getMRICompositeChildren(ReadOnlyMRIAttribute parent, CompositeData compositeDataValue) {
        IConnectionHandle handle = parent.getHandle();
        MRI baseMRI = parent.getMRI();
        ArrayList<ReadOnlyMRIAttribute> elements = new ArrayList<ReadOnlyMRIAttribute>();
        for (String key : compositeDataValue.getCompositeType().keySet()) {
            elements.add(new ReadOnlyMRIAttribute(handle, new MRI(baseMRI, key), compositeDataValue.get(key)));
        }
        return PartitionedList.create(elements);
    }

    private static Collection<?> getTabularChildren(IReadOnlyAttribute parent, TabularData tabularDataValue) {
        ArrayList<ReadOnlyIndexedAttributeChild> elements = new ArrayList<ReadOnlyIndexedAttributeChild>();
        int i = 0;
        for (Object value : tabularDataValue.values()) {
            if (!(value instanceof CompositeData)) continue;
            elements.add(new ReadOnlyIndexedAttributeChild(parent, i++, value));
        }
        return PartitionedList.create(elements);
    }

    private static Collection<?> getCollectionChildren(IReadOnlyAttribute parent, Collection<?> collectionValue) {
        ArrayList<ReadOnlyIndexedAttributeChild> elements = new ArrayList<ReadOnlyIndexedAttributeChild>(collectionValue.size());
        int i = 0;
        for (Object o : collectionValue) {
            elements.add(new ReadOnlyIndexedAttributeChild(parent, i++, o));
        }
        return PartitionedList.create(elements);
    }

    private static Collection<?> getMapChildren(IReadOnlyAttribute parent, Map<?, ?> mapValue) {
        ArrayList<ReadOnlyKeyedAttributeChild> elements = new ArrayList<ReadOnlyKeyedAttributeChild>();
        for (Map.Entry<?, ?> entry : mapValue.entrySet()) {
            elements.add(new ReadOnlyKeyedAttributeChild(parent, entry.getKey(), entry.getValue()));
        }
        return PartitionedList.create(elements);
    }
}

