/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.MBeanAttributeInspector;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.ui.misc.ErrorDialog;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import java.util.logging.Level;
import javax.management.ObjectName;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class AttributeSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private MBeanAttributeInspector m_client;

    public AttributeSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection str;
        if (part instanceof MBeanTreeSectionPart && !selection.isEmpty() && (str = (IStructuredSelection)selection).getFirstElement() instanceof ObjectName) {
            try {
                this.m_client.setBean((ObjectName)str.getFirstElement());
            }
            catch (Exception e) {
                MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, "Failed to load attributes", e);
                String error = Messages.AttributeSectionPart_FAILED_TO_LOAD_ATTRIBUTES;
                ErrorDialog.showException((Shell)this.getSection().getShell(), (String)error, (String)error, (Throwable)e);
            }
        }
    }

    protected Composite createClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        IDialogSettings settings = DialogSettings.getOrCreateSection((IDialogSettings)MBeanBrowserPlugin.getDefault().getMCDialogSettings(), (String)"mbean_attribute_inspector");
        this.m_client = new MBeanAttributeInspector(this.getConsoleEditor(), section, settings, (IConnectionHandle)form.getInput());
        return this.m_client;
    }

    private ConsoleEditor getConsoleEditor() {
        return (ConsoleEditor)((IFormPage)this.getManagedForm().getContainer()).getEditor();
    }

    protected void initializeSection(Section section) {
    }
}

