/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.MRIAttribute;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.UpdateIntervalManager;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.VisualizeAction;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.services.IAttribute;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.services.IUpdateInterval;
import com.jrockit.mc.rjmx.services.ServiceNotAvailableException;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.celleditors.UpdateIntervalEditingSupport;
import com.jrockit.mc.rjmx.ui.column.AsyncService;
import com.jrockit.mc.rjmx.ui.column.AttributeInspector;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.SortObjectProvider;
import com.jrockit.mc.rjmx.ui.column.TypedLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.handlers.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.management.Descriptor;
import javax.management.ObjectName;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.services.IServiceLocator;

public class MBeanAttributeInspector
extends AttributeInspector {
    private static final int MAX_DESCRIPTORS = 8;
    private static final int TOOLTIP_MAX_LENGTH = 100;
    private List<ReadOnlyMRIAttribute> attributes = new ArrayList<ReadOnlyMRIAttribute>();
    private IConnectionHandle connection;
    private Column displayNameColumn = new Column(Messages.MBeanAttributeInspector_DISPLAY_NAME_COLUMN_HEADER, "displayName", (ColumnLabelProvider)new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        protected String getTextTyped(IReadOnlyAttribute element) {
            return element instanceof ReadOnlyMRIAttribute ? MBeanAttributeInspector.this.getDisplayNameText((ReadOnlyMRIAttribute)element) : element.getInfo().getName();
        }
    });
    private Column updateColumn = new Column(Messages.MBeanAttributeInspector_UPDATE_INTERVAL_COLUMN_HEADER, "update", (ColumnLabelProvider)new UpdateColumnLabelProvider());
    private Column descriptionColumn = new Column(Messages.MBeanAttributeInspector_DESCRIPTION_COLUMN_HEADER, "description", (ColumnLabelProvider)new TypedLabelProvider<ReadOnlyMRIAttribute>(ReadOnlyMRIAttribute.class){

        protected String getTextTyped(ReadOnlyMRIAttribute element) {
            return MBeanAttributeInspector.this.getDescriptionText(element);
        }
    });
    private AsyncService asyncService = new AsyncService();
    private IHandler refreshHandler = new AbstractHandler(){

        public Object execute(ExecutionEvent event) throws ExecutionException {
            MBeanAttributeInspector.this.asyncRefresh(true, MBeanAttributeInspector.this.attributes);
            return null;
        }
    };
    private ConsoleEditor consoleEditor;

    public MBeanAttributeInspector(ConsoleEditor consoleEditor, Composite parent, IDialogSettings settings, IConnectionHandle connectionHandle) {
        super(parent, settings);
        this.consoleEditor = consoleEditor;
        this.connection = connectionHandle;
        this.getViewer().getTree().setData("name", (Object)"mbeanbrowser.AttributesTab.AttributesTree");
        this.enableValueEditing(new Runnable(){

            @Override
            public void run() {
                MBeanAttributeInspector.this.asyncRefresh(false, MBeanAttributeInspector.this.attributes);
            }
        });
        this.updateColumn.setEditingSupport((EditingSupport)new UpdateIntervalEditingSupportWithRefresh((ColumnViewer)this.getViewer()));
        this.addVirtualColumns(new IColumn[]{this.displayNameColumn, this.updateColumn, this.descriptionColumn});
        this.nameColumn.setLabelProvider((ColumnLabelProvider)new TypedLabelProvider<ReadOnlyMRIAttribute>(ReadOnlyMRIAttribute.class){

            protected String getDefaultText(Object element) {
                return element instanceof IReadOnlyAttribute ? ((IReadOnlyAttribute)element).getInfo().getName() : (element == null ? "" : element.toString());
            }

            public Font getFont(Object element) {
                if (element instanceof IAttribute) {
                    return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
                }
                if (element instanceof IReadOnlyAttribute) {
                    return JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
                }
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont");
            }

            protected Image getImageTyped(ReadOnlyMRIAttribute element) {
                GraphSettingRegistry gsr = (GraphSettingRegistry)MBeanAttributeInspector.this.connection.getServiceOrNull(GraphSettingRegistry.class);
                if (gsr != null) {
                    return gsr.getColorThumbnail(element.getMRI());
                }
                return null;
            }

            protected Image getToolTipImageTyped(ReadOnlyMRIAttribute element) {
                return this.getImage(element);
            }

            protected Color getBackgroundTyped(ReadOnlyMRIAttribute element) {
                Descriptor desc;
                IMRIMetaData metaData = MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)MBeanAttributeInspector.this.connection, (MRI)element.getMRI());
                Descriptor descriptor = desc = metaData == null ? null : MRIMetaDataToolkit.getDescriptor((IMRIMetaDataProvider)metaData);
                if (desc != null && "true".equals(desc.getFieldValue("synthetic"))) {
                    return MBeanAttributeInspector.this.getDisplay().getSystemColor(22);
                }
                return null;
            }

            protected String getToolTipTextTyped(ReadOnlyMRIAttribute element) {
                Descriptor desc;
                StringBuilder sb = new StringBuilder();
                sb.append(com.jrockit.mc.rjmx.ui.column.Messages.AttributeInspector_NAME_COLUMN_HEADER).append(": ").append(this.shorten(this.getText(element))).append("\n");
                sb.append(Messages.MBeanAttributeInspector_DISPLAY_NAME_COLUMN_HEADER).append(": ").append(this.shorten(MBeanAttributeInspector.this.getDisplayNameText(element))).append("\n");
                sb.append(Messages.MBeanAttributeInspector_DESCRIPTION_COLUMN_HEADER).append(": ").append(this.shorten(MBeanAttributeInspector.this.getDescriptionText(element))).append("\n");
                sb.append(com.jrockit.mc.rjmx.ui.column.Messages.AttributeInspector_VALUE_COLUMN_HEADER).append(": ").append(this.shorten(TypeHandling.getValueString((Object)element.getValue()))).append("\n");
                sb.append(com.jrockit.mc.rjmx.ui.column.Messages.AttributeInspector_TYPE_COLUMN_HEADER).append(": ").append(this.shorten(TypeHandling.simplifyType((String)element.getInfo().getType()))).append("\n");
                IMRIMetaData metaData = MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)MBeanAttributeInspector.this.connection, (MRI)element.getMRI());
                Descriptor descriptor = desc = metaData == null ? null : MRIMetaDataToolkit.getDescriptor((IMRIMetaDataProvider)metaData);
                if (desc != null && desc.getFields() != null && desc.getFields().length > 0) {
                    sb.append(Messages.MBeanAttributeInspector_DESCRIPTOR).append(":\n ");
                    String[] fields = desc.getFields();
                    int i = 0;
                    while (i < Math.min(fields.length, 8)) {
                        sb.append(this.shorten(fields[i])).append("\n ");
                        ++i;
                    }
                }
                return sb.toString().trim();
            }

            private String shorten(String s) {
                if (s.length() > 100) {
                    return s.subSequence(0, 100) + "...";
                }
                return s;
            }
        });
        InFocusHandlerActivator activator = new InFocusHandlerActivator(ActionFactory.REFRESH.getCommandId(), this.refreshHandler);
        this.getViewer().getControl().addFocusListener((FocusListener)activator);
        this.setupDoubleClickListener();
        this.addContextMenuActions();
        this.updateColumn((IColumn)this.nameColumn);
    }

    private void setupDoubleClickListener() {
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object elementNode = selection.getFirstElement();
                MBeanAttributeInspector.this.getViewer().setExpandedState(elementNode, !MBeanAttributeInspector.this.getViewer().getExpandedState(elementNode));
            }
        });
    }

    private void addContextMenuActions() {
        this.menuManager.add((IContributionItem)new Separator());
        this.menuManager.add(Toolkit.createPushItem((IServiceLocator)PlatformUI.getWorkbench(), (ActionFactory)ActionFactory.REFRESH));
        this.menuManager.add((IAction)new VisualizeAction(this.consoleEditor, (ISelectionProvider)this.getViewer()));
        this.menuManager.add((IContributionItem)new UpdateIntervalManager(this.getViewer()).getUpdateIntervalMenu());
    }

    public void setBean(ObjectName name) throws ServiceNotAvailableException {
        this.attributes.clear();
        try {
            for (MRI mri : ((IMRIMetaDataService)this.connection.getServiceOrThrow(IMRIMetaDataService.class)).getAvailableMRIsOnServer(name)) {
                if (mri.getType() != MRI.Type.ATTRIBUTE || mri.isCompositeChild()) continue;
                this.attributes.add(this.createMBeanAttribute(this.connection, mri));
            }
        }
        catch (ConnectionClosedException connectionClosedException) {
            // empty catch block
        }
        this.setAttributes(this.attributes);
        this.asyncRefresh(true, this.attributes);
    }

    private ReadOnlyMRIAttribute createMBeanAttribute(IConnectionHandle handle, MRI mri) {
        boolean editable;
        IMRIMetaData metaData = MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)handle, (MRI)mri);
        boolean bl = editable = metaData != null && MRIMetaDataToolkit.isWritable((IMRIMetaDataProvider)metaData);
        if (editable) {
            return new MRIAttribute(handle, mri);
        }
        return new ReadOnlyMRIAttribute(handle, mri);
    }

    private String getDisplayNameText(ReadOnlyMRIAttribute attribute) {
        return MRIMetaDataToolkit.getDisplayName((IConnectionHandle)this.connection, (MRI)attribute.getMRI());
    }

    private String getDescriptionText(ReadOnlyMRIAttribute attribute) {
        return MRIMetaDataToolkit.getDescription((IConnectionHandle)this.connection, (MRI)attribute.getMRI());
    }

    private void asyncRefresh(final boolean fullRefresh, final List<ReadOnlyMRIAttribute> attributes) {
        this.asyncService.submit(new Runnable(){

            @Override
            public void run() {
                ReadOnlyMRIAttribute.refresh(MBeanAttributeInspector.this.connection, attributes);
            }
        }, new Runnable(){

            @Override
            public void run() {
                if (fullRefresh) {
                    MBeanAttributeInspector.this.getViewer().refresh();
                } else {
                    MBeanAttributeInspector.this.getViewer().update(attributes.toArray(), null);
                }
            }
        });
    }

    private static class UpdateColumnLabelProvider
    extends TypedLabelProvider<IUpdateInterval>
    implements SortObjectProvider<Integer> {
        public UpdateColumnLabelProvider() {
            super(IUpdateInterval.class);
        }

        protected String getTextTyped(IUpdateInterval paramater) {
            int val = paramater.getUpdateInterval();
            switch (val) {
                case -1: {
                    return Messages.MBeanAttributeInspector_UPDATE_INTERVAL_DEFAULT;
                }
                case 0: {
                    return Messages.MBeanAttributeInspector_UPDATE_INTERVAL_ONCE;
                }
            }
            return NLS.bind((String)Messages.MBeanAttributeInspector_UPDATE_INTERVAL_MS, (Object)val);
        }

        public Comparable<Integer> getSortObject(Object element) {
            if (element instanceof IUpdateInterval) {
                int updateInterval = ((IUpdateInterval)element).getUpdateInterval();
                switch (updateInterval) {
                    case -1: {
                        return ConsolePlugin.getDefault().getPreferenceStore().getInt("console.ui.communication.update.interval");
                    }
                    case 0: {
                        return 0;
                    }
                }
                return updateInterval;
            }
            return Integer.MIN_VALUE;
        }
    }

    private static class UpdateIntervalEditingSupportWithRefresh
    extends UpdateIntervalEditingSupport {
        public UpdateIntervalEditingSupportWithRefresh(ColumnViewer viewer) {
            super(viewer);
        }

        protected void setValue(Object element, Object value) {
            super.setValue(element, value);
            this.getViewer().refresh(element);
        }
    }
}

