/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.mbeanbrowser.attributes.ReadOnlyAttributeChild;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.util.internal.SimpleAttributeInfo;
import java.lang.reflect.Array;

public class ReadOnlyIndexedAttributeChild
extends ReadOnlyAttributeChild {
    private final int m_index;
    private Object m_value;
    private final IAttributeInfo m_info;

    public ReadOnlyIndexedAttributeChild(IReadOnlyAttribute parent, int index) {
        this(parent, index, Array.get(parent.getValue(), index));
    }

    public ReadOnlyIndexedAttributeChild(IReadOnlyAttribute parent, int index, Object value) {
        super(parent);
        this.m_index = index;
        this.m_value = value;
        this.m_info = this.createAttributeInfo();
    }

    private IAttributeInfo createAttributeInfo() {
        return new SimpleAttributeInfo(this.getName(), this.getType());
    }

    private String getType() {
        Class<?> parentClass = this.getParent().getValue().getClass();
        if (parentClass.isArray() && parentClass.getComponentType().isPrimitive()) {
            return parentClass.getComponentType().getName();
        }
        Object o = this.getValue();
        if (o == null) {
            return Object.class.getName();
        }
        return o.getClass().getName();
    }

    private String getName() {
        return String.valueOf('[') + String.valueOf(this.m_index) + ']';
    }

    public Object getValue() {
        return this.m_value;
    }

    protected void updateValue(Object value) {
        this.m_value = value;
    }

    public IAttributeInfo getInfo() {
        return this.m_info;
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean equals(Object that) {
        if (that instanceof ReadOnlyIndexedAttributeChild) {
            ReadOnlyIndexedAttributeChild thatChild = (ReadOnlyIndexedAttributeChild)that;
            return this.getParent().equals(thatChild.getParent()) && this.getIndex() == thatChild.getIndex();
        }
        return false;
    }

    public int hashCode() {
        return this.getParent().hashCode() ^ this.getIndex();
    }
}

