/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.common.IParent;
import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.AttributeChildToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.services.IUpdateInterval;
import com.jrockit.mc.rjmx.services.ServiceNotAvailableException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IUpdatePolicy;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import com.jrockit.mc.rjmx.subscription.internal.UpdatePolicyToolkit;
import com.jrockit.mc.rjmx.util.internal.SimpleAttributeInfo;
import java.rmi.UnmarshalException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.management.MBeanException;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import org.eclipse.osgi.util.NLS;

public class ReadOnlyMRIAttribute
implements IReadOnlyAttribute,
IParent<Object>,
IUpdateInterval {
    private final IConnectionHandle m_handle;
    private final IAttributeInfo m_info;
    private Object m_value;
    private final MRI m_mri;

    public ReadOnlyMRIAttribute(IConnectionHandle handle, MRI mri) {
        this(handle, mri, null);
    }

    public ReadOnlyMRIAttribute(IConnectionHandle handle, MRI mri, Object value) {
        this.m_info = new SimpleAttributeInfo(this.extractName(mri.getDataPath()), MRIMetaDataToolkit.getAttributeInfo((IConnectionHandle)handle, (MRI)mri).getValueType());
        this.m_handle = handle;
        this.m_mri = mri;
        this.m_value = value;
    }

    private String extractName(String dataPath) {
        int index = dataPath.lastIndexOf(47);
        if (index >= 0) {
            return String.valueOf('#') + dataPath.substring(index + 1);
        }
        return dataPath;
    }

    public boolean refresh() {
        Object newValue;
        block7: {
            newValue = null;
            MRIValue attribute = this.getMBeanHelperService().getAttribute(this.m_mri);
            if (attribute != null) {
                newValue = attribute.getValue();
            }
            if (!(this.m_value == null ? newValue == null : this.m_value.equals(newValue))) break block7;
            return false;
        }
        try {
            this.m_value = newValue;
            return true;
        }
        catch (ConnectionClosedException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.INFO, "Could not refresh ReadOnlyMRIAttribute since the connection was closed");
        }
        catch (UnmarshalException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, NLS.bind((String)"Could not unmarshal the value for attribute {0}: {1}", (Object)this.getMRI().getDataPath(), (Object)e.getMessage()));
        }
        catch (MBeanException e) {
            Throwable cause = ReadOnlyMRIAttribute.unmarshalMBeanException(e);
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, NLS.bind((String)"Server error getting attribute {0}: {1}", (Object)this.getMRI().getDataPath(), (Object)cause.getMessage()), cause);
        }
        catch (Exception e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, NLS.bind((String)"Error getting attribute {0}: {1}", (Object)this.getMRI().getDataPath(), (Object)e.getMessage()), e);
        }
        this.m_value = MRIValue.UNAVAILABLE_VALUE;
        return false;
    }

    public Object getValue() {
        return this.m_value;
    }

    protected IMBeanHelperService getMBeanHelperService() throws ConnectionClosedException, ServiceNotAvailableException {
        return (IMBeanHelperService)this.m_handle.getServiceOrThrow(IMBeanHelperService.class);
    }

    protected void updateValue(Object value) {
        this.m_value = value;
    }

    protected MRI getMRI() {
        return this.m_mri;
    }

    protected IConnectionHandle getHandle() {
        return this.m_handle;
    }

    public IAttributeInfo getInfo() {
        return this.m_info;
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public Collection<?> getChildren() {
        return AttributeChildToolkit.getChildren(this);
    }

    public int getUpdateInterval() {
        return UpdatePolicyToolkit.getUpdateInterval((IConnectionHandle)this.m_handle, (MRI)this.m_mri);
    }

    public void setUpdateInterval(int interval) {
        UpdatePolicyToolkit.setUpdatePolicy((IConnectionHandle)this.m_handle, (MRI)this.m_mri, (IUpdatePolicy)UpdatePolicyToolkit.getUpdatePolicy((int)interval));
    }

    public boolean equals(Object that) {
        return that instanceof ReadOnlyMRIAttribute ? this.getMRI().equals((Object)((ReadOnlyMRIAttribute)that).getMRI()) : false;
    }

    public int hashCode() {
        return this.getMRI().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '{' + this.getMRI() + ',' + this.getValue() + '}';
    }

    public static void refresh(IConnectionHandle connection, List<ReadOnlyMRIAttribute> attributes) {
        HashMap<MRI, ReadOnlyMRIAttribute> attributeMap = new HashMap<MRI, ReadOnlyMRIAttribute>();
        ObjectName mbeanName = null;
        for (ReadOnlyMRIAttribute attribute : attributes) {
            attributeMap.put(attribute.getMRI(), attribute);
            mbeanName = attribute.getMRI().getObjectName();
        }
        try {
            List values = ((IMBeanHelperService)connection.getServiceOrThrow(IMBeanHelperService.class)).getAttributes(attributeMap.keySet());
            for (MRIValue value : values) {
                ((ReadOnlyMRIAttribute)attributeMap.remove(value.getMRI())).updateValue(value.getValue());
            }
        }
        catch (ConnectionClosedException e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.INFO, "Could not refresh attributes since the connection was closed");
            return;
        }
        catch (MBeanException e) {
            Throwable cause = ReadOnlyMRIAttribute.unmarshalMBeanException(e);
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, NLS.bind((String)("Server error getting attributes for " + mbeanName), (Object)cause.getMessage()), cause);
        }
        catch (Exception e) {
            MBeanBrowserPlugin.getDefault().getLogger().log(Level.WARNING, NLS.bind((String)("Error getting attributes for " + mbeanName), (Object)e.getMessage()), e);
        }
        for (ReadOnlyMRIAttribute attribute : attributeMap.values()) {
            attribute.refresh();
        }
    }

    private static Throwable unmarshalMBeanException(MBeanException e) {
        Throwable cause = e.getTargetException();
        if (cause instanceof RuntimeErrorException) {
            cause = ((RuntimeErrorException)cause).getTargetError();
        } else if (cause instanceof RuntimeMBeanException) {
            cause = ((RuntimeMBeanException)cause).getTargetException();
        }
        return cause;
    }
}

