/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.editor.ConsoleEditor;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.ReadOnlyMRIAttribute;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.VisualizeWizardPage;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;

public class VisualizeAction
extends Action {
    private final ConsoleEditor m_consoleEditor;
    private List<MRI> m_numericals = Collections.emptyList();

    public VisualizeAction(ConsoleEditor consoleEditor, ISelectionProvider selectionProvider) {
        super(Messages.VisualizeAction_VISUALIZE_ATTRIBUTE_TEXT);
        this.m_consoleEditor = consoleEditor;
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VisualizeAction.this.m_numericals = VisualizeAction.this.filterForNumericalAttributeDescriptors(event.getSelection());
                VisualizeAction.this.setEnabled(!VisualizeAction.this.m_numericals.isEmpty());
            }
        });
        this.setEnabled(false);
    }

    private List<MRI> filterForNumericalAttributeDescriptors(ISelection selection) {
        List descriptors = ((IStructuredSelection)selection).toList();
        ArrayList<MRI> numericals = new ArrayList<MRI>();
        IMRIMetaDataService mriMetaDataService = (IMRIMetaDataService)this.m_consoleEditor.getConnectionHandle().getServiceOrNull(IMRIMetaDataService.class);
        if (mriMetaDataService == null) {
            return numericals;
        }
        for (Object object : descriptors) {
            if (!(object instanceof ReadOnlyMRIAttribute) || !MRIMetaDataToolkit.isNumerical((IMRIMetaData)mriMetaDataService.getMetaData(((ReadOnlyMRIAttribute)object).getMRI()))) continue;
            numericals.add(((ReadOnlyMRIAttribute)object).getMRI());
        }
        return numericals;
    }

    public void run() {
        VisualizeWizardPage wizardPage = new VisualizeWizardPage(this.m_consoleEditor.getSectionPartManagers(), this.m_numericals);
        OnePageWizardDialog dialog = new OnePageWizardDialog(Display.getCurrent().getActiveShell(), (IWizardPage)wizardPage);
        dialog.setImage(RJMXUIPlugin.getDefault().getImage("add-graph-16.png"));
        dialog.setTitle(Messages.VisualizeAction_VISUALIZE_WIZARD_TITLE_TEXT);
        dialog.open();
    }
}

