/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.attributes;

import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.console.ui.actions.NewVisualizerAction;
import com.jrockit.mc.console.ui.mbeanbrowser.attributes.Messages;
import com.jrockit.mc.console.ui.sections.SectionPartManager;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.ui.misc.AbstractStructuredContentProvider;
import com.jrockit.mc.ui.wizards.IPerformFinishable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.SectionPart;

public final class VisualizeWizardPage
extends WizardPage
implements IPerformFinishable {
    private final SectionPartManager m_sectionPartManager;
    private ListViewer m_listViewer;
    private final List<MRI> m_attributes;

    public VisualizeWizardPage(List<SectionPartManager> sectionPartManagers, List<MRI> attributes) {
        super(Messages.VisualizeWizardPage_CREATE_CHART_TITLE_TEXT);
        this.setImageDescriptor(ConsolePlugin.getDefault().getMCImageDescriptor("toolbar-general-64.png"));
        this.setDescription(Messages.VisualizeWizardPage_SELECT_CHART_TEXT);
        this.setTitle(Messages.VisualizeWizardPage_CREATE_CHART_TITLE_TEXT);
        this.m_sectionPartManager = sectionPartManagers.get(0);
        this.m_attributes = attributes;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData gd1 = new GridData(4, 4, true, true);
        this.m_listViewer = this.createViewer(container);
        this.m_listViewer.getControl().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 1, false, false);
        Control buttons = this.createButtonContainer(container);
        buttons.setLayoutData((Object)gd2);
        container.setLayout((Layout)new GridLayout(2, false));
        this.updatePageComplete(true);
        this.setControl((Control)container);
    }

    private void updatePageComplete(boolean firstTime) {
        boolean hasCharts = !this.getCharts().isEmpty();
        this.setPageComplete(hasCharts);
        if (!hasCharts && !firstTime) {
            this.setErrorMessage(Messages.VisualizeWizardPage_ERROR_TEXT_ONE_CHART_MUST_BE_SELECTED_TEXT);
        } else {
            this.setErrorMessage(null);
        }
    }

    private Control createButtonContainer(Composite parent) {
        Button addButton = new Button(parent, 0);
        addButton.setText(Messages.VisualizeWizardPage_CREATE_CHART_BUTTON_TEXT);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewVisualizerAction action = NewVisualizerAction.createAddChartAction((SectionPartManager)VisualizeWizardPage.this.m_sectionPartManager);
                action.run();
                VisualizeWizardPage.this.m_listViewer.refresh();
                this.selectLastListItem();
                VisualizeWizardPage.this.updatePageComplete(false);
            }

            private void selectLastListItem() {
                IStructuredContentProvider listContentProvider = (IStructuredContentProvider)VisualizeWizardPage.this.m_listViewer.getContentProvider();
                Object[] elements = listContentProvider.getElements((Object)VisualizeWizardPage.this.m_sectionPartManager);
                VisualizeWizardPage.this.m_listViewer.setSelection((ISelection)new StructuredSelection(elements[elements.length - 1]));
            }
        });
        return addButton;
    }

    private ListViewer createViewer(Composite container) {
        ListViewer sectionPartViewer = new ListViewer(container);
        sectionPartViewer.setContentProvider((IContentProvider)new SectionPartContentProvider());
        sectionPartViewer.setLabelProvider((IBaseLabelProvider)new SectionPartLabelProvider());
        sectionPartViewer.setInput((Object)this.m_sectionPartManager);
        sectionPartViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VisualizeWizardPage.this.updatePageComplete(false);
            }
        });
        return sectionPartViewer;
    }

    public boolean performFinish() {
        for (IAttributeVisualizer part : this.getCharts()) {
            for (MRI mri : this.m_attributes) {
                part.add(mri);
            }
        }
        return true;
    }

    private List<IAttributeVisualizer> getCharts() {
        ArrayList<IAttributeVisualizer> list = new ArrayList<IAttributeVisualizer>();
        IStructuredSelection selection = (IStructuredSelection)this.m_listViewer.getSelection();
        for (Object visualizer : selection) {
            if (!(visualizer instanceof CombinedChartSectionPart)) continue;
            list.add((IAttributeVisualizer)((CombinedChartSectionPart)visualizer));
        }
        return list;
    }

    static class SectionPartContentProvider
    extends AbstractStructuredContentProvider {
        SectionPartContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IFormPart> list = new ArrayList<IFormPart>();
            SectionPartManager manager = (SectionPartManager)inputElement;
            for (IFormPart visualizer : manager.getParts()) {
                if (!(visualizer instanceof CombinedChartSectionPart)) continue;
                list.add(visualizer);
            }
            return list.toArray();
        }
    }

    static class SectionPartLabelProvider
    extends LabelProvider {
        SectionPartLabelProvider() {
        }

        public String getText(Object element) {
            return ((SectionPart)element).getSection().getText();
        }
    }
}

