/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.metadata;

import com.jrockit.mc.console.ui.mbeanbrowser.metadata.ConstructorSectionPart;
import com.jrockit.mc.console.ui.mbeanbrowser.metadata.ItemSectionPart;
import com.jrockit.mc.console.ui.mbeanbrowser.metadata.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.metadata.MetadataModel;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public final class MetadataSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private ItemSectionPart itemInformationSectionPart;
    private IFormPart constructorInformationSectionPart;

    public MetadataSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    protected Composite createClient(IManagedForm managedForm, FormToolkit formToolkit, Composite section) {
        SashForm sashForm = new SashForm(section, 512);
        this.itemInformationSectionPart = new ItemSectionPart((Composite)sashForm, managedForm.getToolkit(), "mbean.tab.details.information.item");
        managedForm.addPart((IFormPart)this.itemInformationSectionPart);
        this.itemInformationSectionPart.refresh();
        this.constructorInformationSectionPart = new ConstructorSectionPart((Composite)sashForm, managedForm.getToolkit(), "mbean.tab.details.information.constructor");
        managedForm.addPart(this.constructorInformationSectionPart);
        this.constructorInformationSectionPart.refresh();
        return sashForm;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        if (!selection.isEmpty() && part instanceof MBeanTreeSectionPart) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            MetadataModel model = this.createModel((ObjectName)structuredSelection.getFirstElement());
            this.itemInformationSectionPart.setFormInput(model);
            this.constructorInformationSectionPart.setFormInput((Object)model);
        }
    }

    private MetadataModel createModel(ObjectName objectName) {
        IConnectionHandle handle = (IConnectionHandle)this.getManagedForm().getInput();
        try {
            MBeanServerConnection connection = (MBeanServerConnection)handle.getServiceOrThrow(MBeanServerConnection.class);
            try {
                return new MetadataModel(objectName, connection.getMBeanInfo(objectName));
            }
            catch (InstanceNotFoundException e) {
                if (((IMBeanHelperService)handle.getServiceOrDummy(IMBeanHelperService.class)).getMBeanInfo(objectName) != null) {
                    throw e;
                }
            }
        }
        catch (ConnectionClosedException connection) {
        }
        catch (Exception e) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.MetadataSectionPart_ERROR_GETTING_MBEANINFO_TEXT, (Throwable)e);
        }
        return null;
    }

    protected void initializeSection(Section section) {
    }
}

