/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.notifications;

import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.InformationProvider;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationsModel;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.sections.FieldTreeViewerSectionPart;
import java.io.IOException;
import java.util.Observable;
import java.util.Observer;
import javax.management.JMException;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

class NotificationInfoSectionPart
extends FieldTreeViewerSectionPart {
    private static final Field[] FIELD_PROTOTYPES = new Field[]{InformationProvider.FIELD_INFORMATION};
    private NotificationsModel m_model;
    private Observer m_observer;

    public NotificationInfoSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier, FIELD_PROTOTYPES, MBeanBrowserPlugin.getDefault().getMCDialogSettings());
    }

    protected Composite createRightControl(Composite parent) {
        Composite container = this.getFormToolkit().createComposite(parent);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        Button button = this.createSubscribeButton(this.getManagedForm(), this.getManagedForm().getToolkit(), container);
        button.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        return container;
    }

    private Button createSubscribeButton(IManagedForm form, FormToolkit toolkit, Composite parent) {
        final Button subscribeButton = toolkit.createButton(parent, Messages.NotificationInfoSectionPart_SUBSCRIBE_BUTTON_TEXT, 32);
        subscribeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String errorTitle = null;
                errorTitle = !NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled() ? Messages.NotificationInfoSectionPart_ERROR_ENABLE_JMX_SUBSCRIPTION_TEXT : Messages.NotificationInfoSectionPart_ERROR_REMOVING_JMX_SUBSCRIPTION_TEXT;
                try {
                    NotificationInfoSectionPart.this.m_model.setSubscriptionEnabled(!NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled());
                }
                catch (IOException e1) {
                    DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)errorTitle, (String)e1.getMessage(), (Throwable)e1);
                }
                catch (JMException e1) {
                    DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)errorTitle, (String)e1.getMessage(), (Throwable)e1);
                }
            }
        });
        this.m_observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DisplayToolkit.safeAsyncExec((Widget)NotificationInfoSectionPart.this.getSection(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        subscribeButton.setSelection(NotificationInfoSectionPart.this.m_model.getSubscriptionEnabled());
                        subscribeButton.setEnabled(NotificationInfoSectionPart.this.m_model.supportsSubscriptions());
                        NotificationInfoSectionPart.this.getTreeViewer().refresh();
                    }
                });
            }
        };
        return subscribeButton;
    }

    public boolean setFormInput(Object input) {
        this.removeObserver();
        if (input != null) {
            this.m_model = (NotificationsModel)input;
            this.m_model.addObserver(this.m_observer);
            this.getViewer().setInput(input);
            this.m_observer.update(null, null);
        }
        return true;
    }

    private void removeObserver() {
        if (this.m_model != null) {
            this.m_model.deleteObserver(this.m_observer);
        }
    }

    protected void setupSelectionListeners() {
    }

    public void initializePart() {
        super.initializePart();
        this.getTreeViewer().setContentProvider((IContentProvider)new InformationProvider());
        this.getTreeViewer().setAutoExpandLevel(-1);
        this.setSortColumn(InformationProvider.FIELD_INFORMATION, true);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.NotificationInfoSectionPart_NOTICATION_INFORMATION_TITLE_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void dispose() {
        this.removeObserver();
        if (this.m_model != null) {
            this.m_model.dispose();
        }
    }
}

