/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.notifications;

import com.jrockit.mc.console.ui.mbeanbrowser.notifications.MBeanNotificationLogSectionPart;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationInfoSectionPart;
import com.jrockit.mc.console.ui.mbeanbrowser.notifications.NotificationsModel;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeSectionPart;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import com.jrockit.mc.ui.sections.MCSectionPart;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class NotificationSectionPart
extends MCClientSectionPart
implements IPartSelectionListener {
    private NotificationInfoSectionPart infoSectionPart;
    private MBeanNotificationLogSectionPart logSectionPart;
    private Object m_lastName;
    private final Map<ObjectName, NotificationsModel> m_notificationModels = new HashMap<ObjectName, NotificationsModel>();

    public NotificationSectionPart(Composite parent, FormToolkit toolkit, String sectionIdentifier) {
        super(parent, toolkit, 4096, sectionIdentifier);
    }

    protected Composite createClient(IManagedForm managedForm, FormToolkit formToolkit, Composite section) {
        SashForm sashForm = new SashForm(section, 512);
        this.infoSectionPart = new NotificationInfoSectionPart((Composite)sashForm, managedForm.getToolkit(), MCSectionPart.getAccessibilityDescriptionStyle(), "mbean.tab.details.information.tab.general");
        managedForm.addPart((IFormPart)this.infoSectionPart);
        this.infoSectionPart.refresh();
        this.logSectionPart = new MBeanNotificationLogSectionPart((Composite)sashForm, managedForm.getToolkit(), MCSectionPart.getAccessibilityDescriptionStyle(), "mbean.tab.details.information.tab.log");
        managedForm.addPart((IFormPart)this.logSectionPart);
        this.logSectionPart.refresh();
        sashForm.setWeights(new int[]{1, 3});
        return sashForm;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection structuredSelection;
        ObjectName objectName;
        if (part instanceof MBeanTreeSectionPart && !selection.isEmpty() && !(objectName = (ObjectName)(structuredSelection = (IStructuredSelection)selection).getFirstElement()).equals(this.m_lastName)) {
            this.m_lastName = objectName;
            try {
                NotificationsModel model;
                block6: {
                    model = null;
                    try {
                        model = this.getOrCreateNotificationsModel(objectName);
                    }
                    catch (ConnectionClosedException connectionClosedException) {
                    }
                    catch (InstanceNotFoundException e) {
                        if (((IMBeanHelperService)this.getConnectionHandle().getServiceOrDummy(IMBeanHelperService.class)).getMBeanInfo(objectName) == null) break block6;
                        throw e;
                    }
                }
                this.infoSectionPart.setFormInput(model);
                this.logSectionPart.setFormInput(model);
            }
            catch (Exception e) {
                DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.NotificationSectionPart_PROBLEM_GETTING_NOTIFICATION_INFO_TEXT, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    private NotificationsModel getOrCreateNotificationsModel(ObjectName mbean) throws Exception {
        NotificationsModel model = this.m_notificationModels.get(mbean);
        if (model == null) {
            model = new NotificationsModel(mbean, (MBeanServerConnection)this.getConnectionHandle().getServiceOrThrow(MBeanServerConnection.class));
            this.m_notificationModels.put(mbean, model);
        }
        return model;
    }

    protected void initializeSection(Section section) {
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }

    public void dispose() {
        for (NotificationsModel model : this.m_notificationModels.values()) {
            model.dispose();
        }
        super.dispose();
    }
}

