/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.tree;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.ui.fields.FilterMatcher;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class MBeanTreeFilter
extends ViewerFilter {
    private final Job job;
    private String filterText;

    MBeanTreeFilter(Job job) {
        this.job = job;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ITreeNode node = (ITreeNode)element;
        ITreeNode[] children = node.getChildren();
        if (children == null) {
            ILabelProvider labelProvider = (ILabelProvider)((StructuredViewer)viewer).getLabelProvider();
            while (node != null) {
                if (this.matchesFilterText(labelProvider.getText((Object)node))) {
                    return true;
                }
                node = node.getParent();
            }
        } else {
            ITreeNode[] iTreeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode element2 = iTreeNodeArray[n2];
                if (this.select(viewer, element, element2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setFilterText(String text) {
        this.job.cancel();
        this.filterText = text == null || text.length() == 0 ? null : FilterMatcher.autoAddKleene((String)text, (FilterMatcher.Where)FilterMatcher.Where.AFTER);
        this.job.schedule(600L);
    }

    private boolean matchesFilterText(String stringToTest) {
        if (this.filterText != null) {
            return FilterMatcher.getInstance().matchCaseUnsensitive(stringToTest, this.filterText);
        }
        return true;
    }
}

