/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.mbeanbrowser.tree;

import com.jrockit.mc.console.ui.actions.MBeanAutomaticRefreshAction;
import com.jrockit.mc.console.ui.mbeanbrowser.MBeanBrowserPlugin;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.MBeanTreeFilter;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.Messages;
import com.jrockit.mc.console.ui.mbeanbrowser.tree.ObjectNameProvider;
import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeOrderRefreshJob;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeRefreshJob;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeSorter;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.MCLayoutFactory;
import com.jrockit.mc.ui.sections.ViewerSectionPart;
import javax.management.ObjectName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class MBeanTreeSectionPart
extends ViewerSectionPart {
    private MBeanTreeFilter m_filter;
    private static Color filterColorForeground = UIPlugin.getDefault().getFontColorToolkit().getFilterForegroundColor();
    private static Color filterColorBackground = UIPlugin.getDefault().getFontColorToolkit().getFilterBackgroundColor();

    public MBeanTreeSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.MBeanTreeSectionPart_MBEAN_TREE_TITLE_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            section.setDescription(section.getText());
        }
    }

    public void initializePart() {
        super.initializePart();
        if (!this.getConnectionHandle().isConnected()) {
            return;
        }
        this.m_filter = new MBeanTreeFilter((Job)new MBeanTreeRefreshJob((TreeViewer)this.m_viewer));
        this.getTreeViewer().setFilters(new ViewerFilter[]{this.m_filter});
        this.getTreeViewer().setInput((Object)this.getConnectionHandle());
        this.addRefreshAction();
        this.setupDoubleClickListener();
        this.selectDefaultBean();
    }

    private void selectDefaultBean() {
        try {
            ObjectName bean = ObjectName.getInstance("java.lang", "type", "OperatingSystem");
            ITreeNode node = ((MBeanTreeContentProvider)this.getTreeViewer().getContentProvider()).findNode(bean);
            if (node != null) {
                this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node), true);
            } else {
                MBeanBrowserPlugin.getDefault().getLogger().warning("Couldn't find " + bean + " in MBean tree");
            }
        }
        catch (Exception e) {
            MBeanBrowserPlugin.getDefault().getLogger().warning("Failed to select OperatingSystem bean: " + e);
        }
    }

    private void addRefreshAction() {
        this.getMCToolBarManager().add((IAction)new MBeanAutomaticRefreshAction(this.getConnectionHandle(), new IRefreshable(){

            public boolean refresh() {
                DisplayToolkit.safeAsyncExec((Widget)MBeanTreeSectionPart.this.getTreeViewer().getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MBeanTreeSectionPart.this.updateMBeanTreeStructure();
                    }
                });
                return true;
            }
        }));
    }

    protected void updateMBeanTreeStructure() {
        this.updateMBeanTreeWithinOneSecond();
    }

    private void updateMBeanTreeWithinOneSecond() {
        MBeanTreeSectionPart channel = this;
        DisplayToolkit.safeWithinExec((Widget)this.getSection(), (int)1000, (Object)((Object)channel), (Runnable)new Runnable(){

            @Override
            public void run() {
                new MBeanTreeOrderRefreshJob(MBeanTreeSectionPart.this.getTreeViewer()).schedule();
            }
        });
    }

    protected Composite createTopControl(FormToolkit toolkit, Composite parent) {
        Composite filterComposite = toolkit.createComposite(parent);
        toolkit.paintBordersFor(filterComposite);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        filterComposite.setLayout((Layout)layout);
        Label filterLabel = toolkit.createLabel(filterComposite, Messages.MBeanTreeSectionPart_MBEAN_TREE_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(4, 4, false, false));
        final Text filterText = toolkit.createText(filterComposite, "");
        filterText.setLayoutData((Object)new GridData(4, 4, true, false));
        filterText.setToolTipText(Messages.MBeanTreeSectionPart_MBEAN_TREE_FILTER_TOOLTIP_TEXT);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!filterText.isDisposed()) {
                    String text = filterText.getText();
                    if (text == null || text.length() == 0) {
                        filterText.setBackground(null);
                        filterText.setForeground(null);
                        MBeanTreeSectionPart.this.m_filter.setFilterText(null);
                    } else {
                        filterText.setForeground(filterColorForeground);
                        filterText.setBackground(filterColorBackground);
                        MBeanTreeSectionPart.this.m_filter.setFilterText(text);
                    }
                }
            }
        });
        return filterComposite;
    }

    protected Composite createViewerClient(IManagedForm form, FormToolkit formToolkit, Composite section) {
        Composite container = formToolkit.createComposite(section, 0);
        container.setLayout(MCLayoutFactory.createPaintBordersMarginFreeFormPageLayout((int)1));
        Composite top = this.createTopControl(formToolkit, container);
        top.setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)false));
        this.m_viewer = this.createViewer(container);
        this.m_viewer.getControl().setLayoutData(MCLayoutFactory.createFormPageLayoutData((int)-1, (int)-1, (boolean)true, (boolean)true));
        return container;
    }

    protected Viewer createViewer(Composite parent) {
        Tree tree = this.getFormToolkit().createTree(parent, 0);
        tree.setData("name", (Object)"mbeanbrowser.MBeanTree");
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, true));
        viewer.setSorter((ViewerSorter)new MBeanTreeSorter());
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(viewer));
        return viewer;
    }

    protected void setupSelectionListeners() {
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MBeanTreeSectionPart.this.getManagedForm().fireSelectionChanged((IFormPart)MBeanTreeSectionPart.this, new ObjectNameProvider(event.getSelectionProvider()).getSelection());
            }
        });
    }

    private void setupDoubleClickListener() {
        this.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ITreeNode elementNode = (ITreeNode)selection.getFirstElement();
                if (elementNode.getAdapter(ObjectName.class) == null) {
                    MBeanTreeSectionPart.this.getTreeViewer().setExpandedState((Object)elementNode, !MBeanTreeSectionPart.this.getTreeViewer().getExpandedState((Object)elementNode));
                }
            }
        });
    }

    private TreeViewer getTreeViewer() {
        return (TreeViewer)this.getViewer();
    }

    private IConnectionHandle getConnectionHandle() {
        return (IConnectionHandle)this.getManagedForm().getInput();
    }
}

