/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.HistoricalDataPlugin;
import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.ui.ConsolePlugin;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.ui.dialogs.MCTitleAreaDialog;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.util.HashSet;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

class DisplayingAttributesDialog
extends MCTitleAreaDialog {
    private CheckboxTableViewer viewer;
    private MRI[] disabledAttributes;
    private final GraphSettingRegistry m_colorManager;

    public DisplayingAttributesDialog(Shell parentShell, GraphSettingRegistry manager) {
        super(parentShell);
        this.m_colorManager = manager;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        contents.getShell().setSize(600, 500);
        this.setMessage(Messages.HistoricalDataPage_MESSAGE_ATTRIBUTES_PRESENT);
        this.setTitle(Messages.HistoricalDataPage_TITLE_ENABLE_ATTRIBUTES);
        this.getShell().setText(Messages.HistoricalDataPage_TITLE_ENABLE_ATTRIBUTES);
        this.setTitleImage(ConsolePlugin.getDefault().getImage("attribute-browser-wiz.gif"));
        DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogParent = (Composite)super.createDialogArea(parent);
        this.getShell().setImage(HistoricalDataPlugin.getDefault().getImage("historic-data-16.gif"));
        Composite client = new Composite(dialogParent, 2048);
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        client.setLayout((Layout)layout);
        Table table = new Table(client, 2080);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                if (element instanceof MRI) {
                    return DisplayingAttributesDialog.this.m_colorManager.getColorThumbnail((MRI)element);
                }
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof MRI) {
                    return ((MRI)element).getDataPath();
                }
                return null;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.viewer.getTable().setLayoutData((Object)new GridData(1808));
        return this.dialogArea;
    }

    public void okPressed() {
        HashSet<Object> attr = new HashSet<Object>();
        int i = 0;
        while (i < this.viewer.getTable().getItemCount()) {
            if (!this.viewer.getChecked(this.viewer.getElementAt(i))) {
                attr.add(this.viewer.getElementAt(i));
            }
            ++i;
        }
        this.disabledAttributes = attr.toArray(new MRI[attr.size()]);
        super.okPressed();
    }

    public MRI[] getDisabledAttributes() {
        return this.disabledAttributes;
    }

    public void setAttributes(MRI[] descriptors, MRI[] enabledDescriptors) {
        this.viewer.setInput((Object)descriptors);
        this.viewer.setCheckedElements((Object[])enabledDescriptors);
    }
}

