/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContext;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.Range;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

public class FetchRange
extends Job {
    private final PersistenceContext m_persistenceContext;
    private final MRI[] m_attributes;
    private volatile long m_startTime = Long.MIN_VALUE;
    private volatile long m_endTime = Long.MIN_VALUE;

    public FetchRange(PersistenceContext pc, MRI[] attributes) {
        super(Messages.FetchRange_FETCHING_RANGE);
        this.setUser(false);
        this.m_persistenceContext = pc;
        this.m_attributes = attributes;
    }

    public long getDataStartTime() {
        return this.m_startTime;
    }

    public long getDataEndTime() {
        return this.m_endTime;
    }

    public IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.HistoricalDataPage_MONITOR_READING_DATA_TASK_NAME, -1);
        try {
            Range range = this.extractRange();
            if (range != null) {
                this.m_startTime = range.getMinValue().longValue();
                this.m_endTime = range.getMaxValue().longValue();
            }
        }
        catch (IOException e) {
            return StatusFactory.createErr((String)Messages.FetchRange_FETCHING_RANGE_ERROR, (Throwable)e, (boolean)false);
        }
        return StatusFactory.createOk((String)Messages.FetchRange_FETCHING_RANGE_SUCCESSFUL);
    }

    private Range extractRange() throws IOException {
        Range range = null;
        range = this.m_attributes != null ? this.m_persistenceContext.readRangeForAttributes(this.m_attributes) : this.m_persistenceContext.readPersistedRange();
        return range;
    }
}

