/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.FetchRange;
import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContext;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContextImpl;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataChart;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataProvider;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataTable;
import com.jrockit.mc.console.historicaldata.editors.RangeUpdateJob;
import com.jrockit.mc.console.historicaldata.editors.ToggleControlAction;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.IAttributeDataSeriesProvider;
import com.jrockit.mc.rjmx.ui.internal.ZoomInAction;
import com.jrockit.mc.rjmx.ui.internal.ZoomOutAction;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.DateTimeController;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.MCBook;
import com.jrockit.mc.ui.sections.MCClientSectionPart;
import com.jrockit.mc.ui.site.SectionSite;
import java.util.Calendar;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;

public class HistoricalChartSectionPart
extends MCClientSectionPart {
    private final PersistenceContext m_persistenceContext;
    private PersistentDataChart m_chart;
    private PersistentDataTable m_table;
    private DateTimeController m_startControl;
    private DateTimeController m_endControl;
    private ProgressIndicator m_progressIndicator;
    private Button m_showButton;
    private Button m_showAllButton;
    private MCBook m_book;
    private ToggleControlAction m_toggleControlAction;

    public HistoricalChartSectionPart(Composite parent, FormToolkit toolkit, PersistenceContext context) {
        this(parent, toolkit, 322, context);
    }

    public HistoricalChartSectionPart(Composite parent, FormToolkit toolkit, int style, PersistenceContext context) {
        super(parent, toolkit, style, "");
        this.m_persistenceContext = context;
    }

    public void initializeFromXml(Element e) {
        this.m_chart.getChartModel().importBundleMetaDataFromXml(e);
    }

    protected Composite createClient(IManagedForm form, FormToolkit toolkit, Composite parent) {
        this.m_book = new MCBook(parent, 262144);
        toolkit.adapt((Composite)this.m_book);
        this.m_chart = this.createChart(toolkit, (Composite)this.m_book);
        this.m_table = this.createTable(toolkit, (Composite)this.m_book, this.getSite());
        this.getSection().setDescriptionControl((Control)this.createDescriptionControl((Composite)this.getSection(), toolkit));
        this.updateView(UIPlugin.getDefault().getPreferenceStore().getBoolean("accessibility.mode"));
        return this.m_book;
    }

    void updateView(boolean useAccessibilityMode) {
        if (useAccessibilityMode) {
            this.m_book.showPage((Control)this.m_table);
        } else {
            this.m_book.showPage((Control)this.m_chart);
        }
    }

    public void dispose() {
        if (this.m_toggleControlAction != null) {
            this.m_toggleControlAction.dispose();
            this.m_toggleControlAction = null;
        }
        super.dispose();
    }

    protected Composite createDescriptionControl(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(12, false);
        container.setLayout((Layout)layout);
        toolkit.paintBordersFor(container);
        Label separator3 = toolkit.createLabel(container, "", 258);
        separator3.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 12, 1));
        this.createStartTime(toolkit, container);
        this.createEndTime(toolkit, container);
        this.createShowButtons(toolkit, container);
        this.createProgress(container);
        Label separator4 = toolkit.createLabel(container, "", 258);
        separator4.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 12, 1));
        return container;
    }

    public void initialize(IManagedForm form) {
        super.initialize(form);
        this.getMCToolBarManager().add((IAction)new ZoomInAction((ChartComposite)this.m_chart));
        this.getMCToolBarManager().add((IAction)new ZoomOutAction((ChartComposite)this.m_chart));
        this.m_toggleControlAction = new ToggleControlAction(this);
        this.getMCToolBarManager().add((IAction)this.m_toggleControlAction);
    }

    private void createProgress(Composite container) {
        this.m_progressIndicator = new ProgressIndicator(container);
        this.m_progressIndicator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    private void createShowButtons(FormToolkit toolkit, Composite container) {
        this.m_showButton = this.createShowButton(container, toolkit);
        this.m_showButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_showButton.setEnabled(false);
        Label separator2 = toolkit.createLabel(container, "  ", 514);
        separator2.setLayoutData((Object)new GridData(2, 20));
        this.m_showAllButton = this.createShowAllButton(container, toolkit);
        this.m_showAllButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.m_showAllButton.setEnabled(false);
        Label separator5 = toolkit.createLabel(container, "  ", 514);
        separator5.setLayoutData((Object)new GridData(2, 20));
    }

    private void createEndTime(FormToolkit toolkit, Composite container) {
        Label endTimeLabel = toolkit.createLabel(container, Messages.HistoricalChartSectionPart_TIME_END_TEXT);
        endTimeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        DateTime endDate = this.createTimeControl(container, toolkit, 32);
        endDate.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        endDate.setEnabled(false);
        DateTime endTime = this.createTimeControl(container, toolkit, 0x10000080);
        endTime.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        endTime.setEnabled(false);
        this.m_endControl = new DateTimeController(endDate, endTime, Calendar.getInstance());
        this.m_endControl.setEnabled(false);
    }

    private void createStartTime(FormToolkit toolkit, Composite container) {
        Label startTimeLabel = toolkit.createLabel(container, Messages.HistoricalChartSectionPart_START_TIME_TEXT);
        startTimeLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        DateTime starDate = this.createTimeControl(container, toolkit, 32);
        starDate.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        starDate.setEnabled(false);
        DateTime starTime = this.createTimeControl(container, toolkit, 0x10000080);
        starTime.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        starTime.setEnabled(false);
        this.m_startControl = new DateTimeController(starDate, starTime, Calendar.getInstance());
        this.m_startControl.setEnabled(false);
        Label separator = toolkit.createLabel(container, " ");
        separator.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    private Button createShowButton(Composite parent, FormToolkit toolkit) {
        Button button = toolkit.createButton(parent, Messages.HistoricalChartSectionPart_SHOW_BUTTON_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoricalChartSectionPart.this.updateRange();
            }
        });
        return button;
    }

    private Button createShowAllButton(Composite parent, FormToolkit toolkit) {
        Button button = toolkit.createButton(parent, Messages.HistoricalChartSectionPart_RESET_TIME_INTERVAL, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HistoricalChartSectionPart.this.m_startControl.setValue(HistoricalChartSectionPart.this.m_startControl.getMinValue());
                HistoricalChartSectionPart.this.m_endControl.setValue(HistoricalChartSectionPart.this.m_endControl.getMaxValue());
                HistoricalChartSectionPart.this.updateRange();
            }
        });
        return button;
    }

    private DateTime createTimeControl(Composite parent, FormToolkit toolkit, int style) {
        DateTime dt = new DateTime(parent, style);
        toolkit.adapt((Composite)dt);
        return dt;
    }

    private PersistentDataChart createChart(FormToolkit toolkit, Composite container) {
        AttributeChartModel model = new AttributeChartModel(new GraphSettingRegistry("-1"), (IAttributeDataSeriesProvider)new PersistentDataProvider(this.m_persistenceContext));
        PersistentDataChart chart = new PersistentDataChart(container, 0, toolkit, model, (PersistenceContextImpl)this.m_persistenceContext);
        return chart;
    }

    private PersistentDataTable createTable(FormToolkit toolkit, Composite container, SectionSite site) {
        return new PersistentDataTable(container, 0, toolkit, (PersistenceContextImpl)this.m_persistenceContext, site);
    }

    public void initializePart() {
        super.initializePart();
        this.scheduleFetchRange();
    }

    private void scheduleFetchRange() {
        final FetchRange fetchRangeJob = new FetchRange(this.m_persistenceContext, this.m_chart.getChartModel().getAttributesInTable());
        fetchRangeJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (fetchRangeJob.getDataStartTime() != Long.MIN_VALUE && fetchRangeJob.getDataEndTime() != Long.MIN_VALUE) {
                    DisplayToolkit.safeAsyncExec((Widget)HistoricalChartSectionPart.this.getSection(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HistoricalChartSectionPart.this.updateChart(fetchRangeJob.getDataStartTime(), fetchRangeJob.getDataEndTime());
                        }
                    });
                }
            }
        });
        fetchRangeJob.schedule();
    }

    private void updateChart(long start, long end) {
        this.m_startControl.setMinValue(start);
        this.m_startControl.setMaxValue(end);
        this.m_startControl.setValue(start);
        this.m_startControl.setEnabled(true);
        this.m_endControl.setMinValue(start);
        this.m_endControl.setMaxValue(end);
        this.m_endControl.setValue(end);
        this.m_endControl.setEnabled(true);
        this.m_showAllButton.setEnabled(true);
        this.m_showButton.setEnabled(true);
        this.updateRange();
    }

    public void updateRange() {
        RangeUpdateJob job = new RangeUpdateJob(this.m_startControl.getValue(), this.m_endControl.getValue(), new RangeUpdateJob.IRangeUpdateHandler[]{this.m_chart.getRangeUpdateHandler(), this.m_table.getRangeUpdateHandler()});
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                DisplayToolkit.safeAsyncExec((Widget)HistoricalChartSectionPart.this.m_progressIndicator, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HistoricalChartSectionPart.this.m_progressIndicator.beginAnimatedTask();
                    }
                });
            }

            public void done(IJobChangeEvent event) {
                DisplayToolkit.safeAsyncExec((Widget)HistoricalChartSectionPart.this.m_progressIndicator, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        HistoricalChartSectionPart.this.m_progressIndicator.done();
                    }
                });
            }
        });
        job.schedule();
    }

    public PersistentDataChart getPersistentDataChart() {
        return this.m_chart;
    }

    protected void initializeSection(Section section) {
        section.setText(Messages.HistoricalChartSectionPart_NO_HISTORICAL_DATA_4_CONNECTION_TEXT);
    }
}

