/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.HistoricalDataPlugin;
import com.jrockit.mc.console.historicaldata.editors.HistoricalChartSectionPart;
import com.jrockit.mc.console.historicaldata.editors.InformationSectionPart;
import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContextImpl;
import com.jrockit.mc.rjmx.persistence.internal.AttributeBundleImporter;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceReadManager;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.ui.formpage.internal.MCFormPage;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.VerticalSectionLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Element;

public class HistoricalDataTab
extends MCFormPage {
    private final ArrayList<HistoricalChartSectionPart> historicalCharts = new ArrayList();
    private final String connectionUid;
    private final File persistenceDirectory;

    public HistoricalDataTab(FormEditor editor, String uid, File directory) {
        super(editor, "historicalDataPage", Messages.HistoricalDataPage_TITLE);
        this.connectionUid = uid;
        this.persistenceDirectory = directory;
    }

    public Image getTitleImage() {
        return HistoricalDataPlugin.getDefault().getImage("historic-data-16.gif");
    }

    protected void createFormContent(final IManagedForm managedForm) {
        super.createFormContent(managedForm);
        managedForm.getForm().setImage(HistoricalDataPlugin.getDefault().getImage("historic-data-16.gif"));
        managedForm.getForm().getBody().setLayout((Layout)new VerticalSectionLayout());
        managedForm.getForm().setText(Messages.HistoricalDataPage_TITLE);
        this.createGraphs(new AttributeBundleImporter(){

            public void createAndInitializeBundleFromXml(Element e, MRI[] attributes) {
                PersistenceContextImpl context = new PersistenceContextImpl(HistoricalDataTab.this.connectionUid, HistoricalDataTab.this.persistenceDirectory);
                HistoricalChartSectionPart chart = new HistoricalChartSectionPart(managedForm.getForm().getBody(), managedForm.getToolkit(), context);
                managedForm.addPart((IFormPart)chart);
                context.setChart(chart.getPersistentDataChart());
                managedForm.getToolkit().adapt((Composite)chart.getSection());
                chart.initializeFromXml(e);
                chart.getPersistentDataChart().getChartModel().setAttributeDescriptors(attributes);
                chart.getPersistentDataChart().getChartModel().notifyObservers();
                HistoricalDataTab.this.historicalCharts.add(chart);
            }
        });
        if (this.historicalCharts.isEmpty()) {
            this.showHelp(managedForm);
        }
        managedForm.reflow(true);
    }

    private void showHelp(IManagedForm managedForm) {
        Composite parent = managedForm.getForm().getBody();
        FormToolkit toolkit = managedForm.getToolkit();
        InformationSectionPart isp = new InformationSectionPart(parent, toolkit, 256, "com.jrockit.mc.console.ui.historical.data.information");
        managedForm.addPart((IFormPart)isp);
        PersistenceContextImpl context = new PersistenceContextImpl(this.connectionUid, this.persistenceDirectory);
        int style = 256;
        HistoricalChartSectionPart chart = new HistoricalChartSectionPart(managedForm.getForm().getBody(), managedForm.getToolkit(), style, context);
        context.setChart(chart.getPersistentDataChart());
        managedForm.addPart((IFormPart)chart);
        managedForm.getToolkit().adapt((Composite)chart.getSection());
        this.historicalCharts.add(chart);
    }

    public void createGraphs(AttributeBundleImporter factory) {
        try {
            new PersistenceReadManager(this.connectionUid, this.persistenceDirectory).initializePersistedAttributeBundles(factory);
        }
        catch (IOException e) {
            DialogToolkit.showException((Shell)this.getEditor().getSite().getShell(), (String)Messages.HistoricalDataPage_DIALOG_CHART_INITIALIZATION_ERROR_TITLE, (String)Messages.HistoricalDataPage_DIALOG_CHART_INITIALIZATION_MESSAGE, (Throwable)e);
        }
    }
}

