/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContext;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataChart;
import com.jrockit.mc.rjmx.persistence.internal.PersistedData;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceReadManager;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.Range;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.widgets.Display;

class PersistenceContextImpl
implements PersistenceContext {
    private final String connectionUid;
    private final File persistenceDirectory;
    private PersistedData lastReadData;
    private Set<MRI> disabledAttributes;
    private Range lastReadRange;
    private PersistentDataChart chart;

    public PersistenceContextImpl(String uid, File directory) {
        this.persistenceDirectory = directory;
        this.connectionUid = uid;
        this.disabledAttributes = new HashSet<MRI>();
    }

    protected void setChart(PersistentDataChart persistentChart) {
        this.chart = persistentChart;
    }

    MRI[] getAllAttributeDescriptors() {
        if (this.lastReadData == null) {
            return new MRI[0];
        }
        Set attributeDescriptors = this.lastReadData.getAttributeDescriptorSet();
        return attributeDescriptors.toArray(new MRI[attributeDescriptors.size()]);
    }

    void disableAttributes(MRI[] descriptors) {
        this.disabledAttributes.clear();
        MRI[] mRIArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MRI descriptor = mRIArray[n2];
            this.disabledAttributes.add(descriptor);
            ++n2;
        }
    }

    @Override
    public MRI[] getAttributeDescriptors() {
        if (this.lastReadData == null) {
            return new MRI[0];
        }
        HashSet attributeDescriptorsCopy = new HashSet(this.lastReadData.getAttributeDescriptorSet());
        attributeDescriptorsCopy.removeAll(this.disabledAttributes);
        return attributeDescriptorsCopy.toArray(new MRI[attributeDescriptorsCopy.size()]);
    }

    @Override
    public PersistedData readData(long from, long to, int resolution) {
        try {
            this.lastReadData = new PersistenceReadManager(this.connectionUid, this.persistenceDirectory).readPersistedData(from, to, (long)resolution);
            HashSet attributesToDisable = new HashSet(this.lastReadData.getAttributeDescriptorSet());
            if (this.chart != null) {
                attributesToDisable.removeAll(Arrays.asList(this.chart.getChartModel().getAttributesInTable()));
                this.disabledAttributes = new HashSet<MRI>(attributesToDisable);
            } else {
                this.disabledAttributes = new HashSet<MRI>();
            }
        }
        catch (IOException e) {
            this.lastReadData = new PersistedData(from, to, (long)resolution);
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.HistoricalDataPage_ERROR_READING_HISTORICAL_DATA_TITLE, (String)Messages.HistoricalDataPage_ERROR_READING_HISTORICAL_DATA_TEXT, (Throwable)e);
        }
        return this.lastReadData;
    }

    @Override
    public Number getFirstTimestamp() {
        if (this.lastReadRange == null) {
            return null;
        }
        return this.lastReadRange.getMinValue();
    }

    @Override
    public Number getLastTimestamp() {
        if (this.lastReadRange == null) {
            return null;
        }
        return this.lastReadRange.getMaxValue();
    }

    @Override
    public Range readPersistedRange() throws IOException {
        this.lastReadRange = new PersistenceReadManager(this.connectionUid, this.persistenceDirectory).readPersistedRange();
        return this.lastReadRange;
    }

    @Override
    public Range readRangeForAttributes(MRI[] attributes) {
        this.lastReadRange = new PersistenceReadManager(this.connectionUid, this.persistenceDirectory).readPersistedRangeForAttributes(attributes);
        return this.lastReadRange;
    }
}

