/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.common.util.TimeRange;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContextImpl;
import com.jrockit.mc.console.historicaldata.editors.RangeUpdateJob;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeDataSeriesProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.NumberField;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.NanosXAxis;

class PersistentDataChart
extends ChartComposite {
    public PersistentDataChart(Composite parent, int style, FormToolkit toolkit, AttributeChartModel model, PersistenceContextImpl context) {
        super(parent, style, toolkit, model, new FreezeModel(true), new ChartComposite.IChartDataToolTipTextProvider(){

            public String getToolTipText(String seriesName, Number value, MRI attribute) {
                StringBuffer tooltip = new StringBuffer();
                tooltip.append(seriesName);
                tooltip.append(": ");
                tooltip.append(NumberField.formatNumber((Number)value));
                tooltip.append(" (");
                tooltip.append(MBeanPropertiesOrderer.getAttributePath((MRI)attribute));
                tooltip.append(")");
                return tooltip.toString();
            }
        });
        model.setAllowNegativeDisplayOffsets(true);
    }

    protected void createButtons(Composite buttonComposite, FormToolkit toolkit) {
    }

    public RangeUpdateJob.IRangeUpdateHandler getRangeUpdateHandler() {
        return new RangeUpdateJob.IRangeUpdateHandler(){

            @Override
            public void refreshRange(final long startNanos, final long endNanos) {
                DisplayToolkit.safeAsyncExec((Widget)PersistentDataChart.this, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IAttributeDataSeriesProvider provider = PersistentDataChart.this.getChartModel().getDataProvider();
                        provider.setRange(new TimeRange(startNanos, endNanos));
                        DefaultXYGreyChart xyChart = (DefaultXYGreyChart)PersistentDataChart.this.getChartPanel().getChart();
                        ((NanosXAxis)xyChart.getXAxis()).setRange((Number)startNanos, (Number)endNanos);
                        PersistentDataChart.this.updateUI();
                    }
                });
            }
        };
    }
}

