/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.common.util.TimeRange;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContext;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataSeries;
import com.jrockit.mc.rjmx.persistence.internal.PersistedData;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.internal.IAttributeDataSeriesProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import se.hirt.greychart.data.DataChangeEvent;
import se.hirt.greychart.data.DataProvider;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.impl.TimestampedDataProvider;

public class PersistentDataProvider
extends TimestampedDataProvider
implements IAttributeDataSeriesProvider<ITimestampedData> {
    private final HashSet<MRI> disabled = new HashSet();
    private final HashMap<MRI, Double> multiplierMap = new HashMap();
    private final Map<MRI, DataSeries<ITimestampedData>> attributeToSeriesMap = new LinkedHashMap<MRI, DataSeries<ITimestampedData>>();
    private PersistenceContext persistenceContext;
    private TimeRange m_range;

    public PersistentDataProvider(PersistenceContext context) {
        this.persistenceContext = context;
    }

    private void readData() {
        long MAX_SCREEN_SIZE = 4000L;
        if (this.m_range == null || this.persistenceContext == null) {
            return;
        }
        long startMs = this.m_range.getStartTimestamp() / 1000000L;
        long endMs = this.m_range.getEndTimestamp() / 1000000L;
        long displayedXRange = endMs - startMs;
        int resolution = (int)(displayedXRange / (MAX_SCREEN_SIZE * 2L));
        if (resolution < 1) {
            resolution = 1;
        }
        PersistedData currentData = this.persistenceContext.readData(startMs, endMs, resolution);
        MRI[] descriptors = this.persistenceContext.getAttributeDescriptors();
        double[] multipliers = new double[descriptors.length];
        this.removeAllDataSeries();
        int i = 0;
        while (i < descriptors.length) {
            multipliers[i] = this.multiplierMap.containsKey(descriptors[i]) ? this.multiplierMap.get(descriptors[i]) : 1.0;
            List l = currentData.getAttributeEvents(descriptors[i]);
            PersistentDataSeries newSeries = new PersistentDataSeries(l, multipliers[i]);
            if (this.attributeToSeriesMap.keySet().contains(descriptors[i])) {
                this.addDataSeries(this.attributeToSeriesMap.get(descriptors[i]));
            } else {
                this.addDataSeries(newSeries);
                this.attributeToSeriesMap.put(descriptors[i], newSeries);
            }
            ++i;
        }
        if (descriptors.length > 0) {
            this.persistenceContext = null;
        }
        this.fireDataChangeEvent(new DataChangeEvent((DataProvider)this, DataChangeEvent.ChangeType.TYPE_STRUCTURE_CHANGED));
    }

    public void setMultiplier(MRI descriptor, Double multiplier) {
        this.multiplierMap.put(descriptor, multiplier);
    }

    public DataSeries<ITimestampedData> getDataSeries(MRI mri) {
        return this.disabled.contains(mri) ? null : this.attributeToSeriesMap.get(mri);
    }

    public MRI getAttributeDescriptor(DataSeries<ITimestampedData> s) {
        for (MRI descriptor : this.attributeToSeriesMap.keySet()) {
            if (this.attributeToSeriesMap.get(descriptor) != s) continue;
            return descriptor;
        }
        return null;
    }

    public void setRange(TimeRange range) {
        this.m_range = range;
        this.readData();
    }

    public TimeRange getRange() {
        return this.m_range;
    }

    public void setEnabled(MRI mri, boolean enabled) {
        DataSeries<ITimestampedData> ds = this.attributeToSeriesMap.get(mri);
        if (enabled && ds != null) {
            this.disabled.remove(mri);
            this.addDataSeries(ds);
        } else if (!enabled && ds != null) {
            this.disabled.add(mri);
            this.removeDataSeries(ds);
        }
    }
}

