/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.common.util.TimeRange;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContextImpl;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataTableContentProvider;
import com.jrockit.mc.console.historicaldata.editors.PersistentDataTableModel;
import com.jrockit.mc.console.historicaldata.editors.RangeUpdateJob;
import com.jrockit.mc.ui.fields.FieldTableViewer;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.handlers.MCContextMenuManager;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.StringField;
import com.jrockit.mc.ui.site.SectionSite;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PersistentDataTable
extends Composite {
    public static final int FIELD_COUNT;
    public static final Field FIELD_ATTRIBUTE;
    public static final Field FIELD_MINIMUM;
    public static final Field FIELD_MAXIMUM;
    public static final Field FIELD_MEDIAN;
    public static final Field FIELD_AVERAGE;
    public static final Field FIELD_ATTRIBUTE_SPECIFICATION;
    private static Field[] FIELD_PROTOTYPES;
    private final FieldTableViewer m_ftv;
    private final PersistentDataTableModel m_model;

    static {
        int fieldCount = 0;
        FIELD_ATTRIBUTE = new StringField(fieldCount++);
        FIELD_MINIMUM = new StringField(fieldCount++);
        FIELD_MAXIMUM = new StringField(fieldCount++);
        FIELD_MEDIAN = new StringField(fieldCount++);
        FIELD_AVERAGE = new StringField(fieldCount++);
        FIELD_ATTRIBUTE_SPECIFICATION = new StringField(fieldCount++);
        FIELD_COUNT = fieldCount;
        FieldToolkit.initializeFields((String)"com.jrockit.mc.console.historicaldata.editors.fields", PersistentDataTable.class);
        FIELD_ATTRIBUTE.setWidthWeight(100);
        FIELD_MINIMUM.setWidthWeight(50);
        FIELD_MAXIMUM.setWidthWeight(50);
        FIELD_MEDIAN.setWidthWeight(50);
        FIELD_AVERAGE.setWidthWeight(50);
        FIELD_ATTRIBUTE_SPECIFICATION.setWidthWeight(100);
        FIELD_PROTOTYPES = new Field[]{FIELD_ATTRIBUTE, FIELD_MINIMUM, FIELD_MAXIMUM, FIELD_MEDIAN, FIELD_AVERAGE, FIELD_ATTRIBUTE_SPECIFICATION};
    }

    public PersistentDataTable(Composite parent, int style, FormToolkit formToolkit, PersistenceContextImpl context, SectionSite site) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        Table table = formToolkit.createTable((Composite)this, 268501762);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        Field[] fields = FieldToolkit.instantiateFieldArray((Field[])FIELD_PROTOTYPES);
        this.m_ftv = new FieldTableViewer(table, fields);
        this.m_ftv.setContentProvider((IContentProvider)new PersistentDataTableContentProvider());
        this.m_model = new PersistentDataTableModel(context);
        this.m_ftv.setInput((Object)this.m_model);
        MCContextMenuManager menuManager = new MCContextMenuManager(site.getId());
        site.registerContextMenu((MenuManager)menuManager, (ISelectionProvider)this.m_ftv);
        table.setMenu(menuManager.createContextMenu((Control)table));
    }

    public RangeUpdateJob.IRangeUpdateHandler getRangeUpdateHandler() {
        return new RangeUpdateJob.IRangeUpdateHandler(){

            @Override
            public void refreshRange(final long startNanos, final long endNanos) {
                DisplayToolkit.safeAsyncExec((Widget)PersistentDataTable.this.m_ftv.getTable(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PersistentDataTable.this.m_model.setRange(new TimeRange(startNanos, endNanos));
                        PersistentDataTable.this.m_ftv.refresh();
                    }
                });
            }
        };
    }
}

