/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.common.util.TimeRange;
import com.jrockit.mc.console.historicaldata.editors.PersistenceContextImpl;
import com.jrockit.mc.rjmx.persistence.internal.PersistedData;
import com.jrockit.mc.rjmx.persistence.internal.PersistedEvent;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PersistentDataTableModel {
    private final PersistenceContextImpl m_context;
    private TimeRange m_range;
    private PersistedData m_persistedData;

    public PersistentDataTableModel(PersistenceContextImpl context) {
        this.m_context = context;
    }

    public void setRange(TimeRange range) {
        this.m_range = range;
    }

    public TimeRange getRange() {
        return this.m_range;
    }

    public MRI[] getAttributeDescriptors() {
        this.initPersistedData();
        Set attributeDescriptorSet = this.m_persistedData.getAttributeDescriptorSet();
        return attributeDescriptorSet.toArray(new MRI[attributeDescriptorSet.size()]);
    }

    private void initPersistedData() {
        if (this.m_persistedData == null) {
            this.m_persistedData = this.m_context.readData(0L, Long.MAX_VALUE, 1);
        }
    }

    private boolean inRange(long timeStamp) {
        if (this.m_range == null) {
            return true;
        }
        return timeStamp >= this.m_range.getStartTimestamp() && timeStamp <= this.m_range.getEndTimestamp();
    }

    public List<Object> getAttributeValues(MRI descriptor) {
        this.initPersistedData();
        List events = this.m_persistedData.getAttributeEvents(descriptor);
        ArrayList<Object> values = new ArrayList<Object>();
        for (PersistedEvent event : events) {
            if (!this.inRange(event.getTimestamp() * 1000000L)) continue;
            values.add(event.getValue());
        }
        return values;
    }
}

