/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.core.StatusFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

public class RangeUpdateJob
extends Job {
    private final long m_startTime;
    private final long m_endTime;
    private final IRangeUpdateHandler[] m_rangeHandlers;

    public RangeUpdateJob(long startTime, long endTime, IRangeUpdateHandler rangeHandler) {
        this(startTime, endTime, new IRangeUpdateHandler[]{rangeHandler});
    }

    public RangeUpdateJob(long startTime, long endTime, IRangeUpdateHandler[] rangeHandlers) {
        super(Messages.RangeUpdateJob_JOB_NAME);
        this.m_startTime = startTime;
        this.m_endTime = endTime;
        this.m_rangeHandlers = rangeHandlers;
    }

    public IStatus run(IProgressMonitor monitor) {
        long margin = (this.m_endTime - this.m_startTime) / 50L;
        long startNanos = 1000000L * (this.m_startTime - margin);
        long endNanos = 1000000L * (this.m_endTime + margin);
        IRangeUpdateHandler[] iRangeUpdateHandlerArray = this.m_rangeHandlers;
        int n = this.m_rangeHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            IRangeUpdateHandler rangeHandler = iRangeUpdateHandlerArray[n2];
            rangeHandler.refreshRange(startNanos, endNanos);
            ++n2;
        }
        return StatusFactory.createOk((String)Messages.RangeUpdateJob_OK_STATUS);
    }

    public static interface IRangeUpdateHandler {
        public void refreshRange(long var1, long var3);
    }
}

