/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.historicaldata.editors;

import com.jrockit.mc.console.historicaldata.editors.HistoricalChartSectionPart;
import com.jrockit.mc.console.historicaldata.editors.Messages;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.ui.UIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ToggleControlAction
extends Action {
    private final HistoricalChartSectionPart m_sectionPart;
    private IPropertyChangeListener m_propertyChangeListener;

    public ToggleControlAction(HistoricalChartSectionPart sectionPart) {
        super(Messages.ToggleControlAction_ACTION_NAME, 2);
        this.m_sectionPart = sectionPart;
        this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("accessibility-mode-toggle-on-16.png"));
        this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("accessibility-mode-toggle-off-16.png"));
        this.setToolTipText(Messages.ToggleControlAction_TOOLTIP_TEXT);
        this.m_propertyChangeListener = this.createPropertyChangeListener();
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.m_propertyChangeListener);
        this.setChecked(UIPlugin.getDefault().getPreferenceStore().getBoolean("accessibility.mode"));
        this.setId("toggle.accessible");
    }

    private IPropertyChangeListener createPropertyChangeListener() {
        return new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals("accessibility.mode")) {
                    ToggleControlAction.this.setChecked(UIPlugin.getDefault().getAccessibilityMode());
                    ToggleControlAction.this.run();
                }
            }
        };
    }

    public void dispose() {
        if (this.m_propertyChangeListener != null) {
            UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.m_propertyChangeListener);
            this.m_propertyChangeListener = null;
        }
    }

    public void run() {
        this.m_sectionPart.updateView(this.isChecked());
    }
}

