/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterDispatcher;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class ModuleUpdater
extends Thread {
    private static final String DOWNLOAD_DIR_NAME = "download";
    static final String DOWNLOAD_DIR = "update" + UpdateTracking.FILE_SEPARATOR + "download";
    private static final String BACKUP_DIR = "update" + UpdateTracking.FILE_SEPARATOR + "backup";
    public static final String UPDATE_NETBEANS_DIR = "netbeans";
    public static final String UPDATE_JAVA_EXT_DIR = "java_ext";
    public static final String UPDATE_MAIN_DIR = "main";
    private static final String JVM_PARAMS_FILE = "main.properties";
    public static final String NBM_EXTENSION = "nbm";
    public static final String JAR_EXTENSION = "jar";
    public static final String LOG_FILE_NAME = "update.log";
    public static final String LATER_FILE_NAME = "install_later.xml";
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    private static final String TEMP_FILE_NAME = "temporary";
    public static final String UPDATER_JAR = "updater.jar";
    public static final String AUTOUPDATE_UPDATER_JAR_PATH = "netbeans/modules/ext/updater.jar";
    public static final String AUTOUPDATE_UPDATER_JAR_LOCALE_PATTERN = "netbeans/modules/ext/locale/updater(_[a-zA-Z0-9]+)+";
    public static final String EXECUTABLE_FILES_ENTRY = "Info/executables.list";
    private Map<File, Collection<File>> files2clustersForInstall;
    private volatile boolean stop = false;
    private long totalLength;
    private final UpdatingContext context;

    ModuleUpdater(UpdatingContext updatingContext) {
        super("Module Updater");
        this.context = updatingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        try {
            this.checkStop();
            if (this.getClustersForInstall().isEmpty()) {
                this.endRun();
            }
            this.checkStop();
            this.totalLength();
            this.checkStop();
            this.unpack();
            for (File file : UpdateTracking.clusters(true)) {
                this.deleteAdditionalInfo(file);
            }
        }
        catch (Exception exception) {
            XMLUtil.LOG.log(Level.SEVERE, "Error while upgrading", exception);
        }
        finally {
            this.context.runningFinished();
        }
    }

    private void deleteInstallLater(File file) {
        File file2 = new File(file, UpdateTracking.FILE_SEPARATOR + DOWNLOAD_DIR + UpdateTracking.FILE_SEPARATOR + LATER_FILE_NAME);
        if (file2.exists()) {
            file2.delete();
            XMLUtil.LOG.info("File " + file2 + " deleted.");
        }
        for (File file3 = file2.getParentFile(); file3 != null && file3.delete(); file3 = file3.getParentFile()) {
        }
    }

    private void deleteAdditionalInfo(File file) {
        File file2;
        File file3 = new File(file, UpdateTracking.FILE_SEPARATOR + DOWNLOAD_DIR + UpdateTracking.FILE_SEPARATOR + "additional_information.xml");
        if (file3 != null && file3.exists()) {
            file3.delete();
            XMLUtil.LOG.info("File " + file3 + " deleted.");
        }
        File file4 = file2 = file3 == null ? null : file3.getParentFile();
        while (file2 != null && file2.delete()) {
            file2 = file2.getParentFile();
        }
    }

    void endRun() {
        this.stop = true;
    }

    private void checkStop() {
        if (this.stop) {
            if (this.context.isFromIDE()) {
                this.context.unpackingFinished();
            } else {
                System.exit(0);
            }
        }
    }

    private void processFilesForInstall() {
        if (this.context.forInstall() == null) {
            this.files2clustersForInstall = new HashMap<File, Collection<File>>();
            for (File file : UpdateTracking.clusters(true)) {
                Set<File> set = ModuleUpdater.getModulesToInstall(file);
                this.files2clustersForInstall.put(file, set);
                if (this.context.isFromIDE()) continue;
                this.deleteInstallLater(file);
            }
        } else {
            this.files2clustersForInstall = new HashMap<File, Collection<File>>();
            for (File file : this.context.forInstall()) {
                File file2 = ModuleUpdater.getCluster(file);
                if (this.files2clustersForInstall.get(file2) == null) {
                    this.files2clustersForInstall.put(file2, new HashSet());
                }
                this.files2clustersForInstall.get(file2).add(file);
            }
        }
    }

    private static File getCluster(File file) {
        File file2 = null;
        try {
            assert (file.exists()) : file + " for install exists.";
            assert (file.getParentFile() != null) : file + " has parent.";
            assert (DOWNLOAD_DIR_NAME.equalsIgnoreCase(file.getParentFile().getName())) : file + " is in directory " + "download";
            assert (file.getParentFile().getParentFile() != null) : file.getParentFile() + " has parent.";
            assert ("update".equalsIgnoreCase(file.getParentFile().getParentFile().getName())) : file + " is in directory " + "update";
            assert (file.getParentFile().getParentFile().getParentFile() != null) : file.getParentFile().getParentFile() + " has parent.";
            file2 = file.getParentFile().getParentFile().getParentFile();
        }
        catch (NullPointerException nullPointerException) {
            XMLUtil.LOG.log(Level.SEVERE, "getCluster (" + file + ") throws an exception", nullPointerException);
        }
        return file2;
    }

    private Collection<File> getFilesForInstallInCluster(File file) {
        if (this.files2clustersForInstall == null) {
            this.processFilesForInstall();
        }
        return this.files2clustersForInstall.get(file);
    }

    private Collection<File> getClustersForInstall() {
        if (this.files2clustersForInstall == null) {
            this.processFilesForInstall();
        }
        return this.files2clustersForInstall.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void totalLength() {
        this.totalLength = 0L;
        this.context.setLabel(Localization.getBrandedString("CTL_PreparingUnpack"));
        HashSet<File> hashSet = new HashSet<File>();
        for (File object : this.getClustersForInstall()) {
            hashSet.addAll(this.getFilesForInstallInCluster(object));
        }
        this.context.setProgressRange(0L, hashSet.size());
        int n = 0;
        for (File file : hashSet) {
            ZipFile zipFile = null;
            try {
                if (file.getName().endsWith(".jar")) {
                    this.totalLength += file.length();
                } else {
                    zipFile = new JarFile(file);
                    Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        this.checkStop();
                        if (!jarEntry.getName().startsWith(UPDATE_NETBEANS_DIR) && !jarEntry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !jarEntry.getName().startsWith(UPDATE_MAIN_DIR) || jarEntry.isDirectory()) continue;
                        this.totalLength += jarEntry.getSize();
                    }
                }
                this.context.setProgressValue(n++);
            }
            catch (IOException iOException) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot count size of entries in " + file, iOException);
            }
            finally {
                try {
                    if (zipFile == null) continue;
                    zipFile.close();
                }
                catch (IOException iOException) {
                    XMLUtil.LOG.log(Level.WARNING, "While closing " + zipFile + " input stream", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack() {
        Object object;
        long l = 0L;
        this.context.setLabel("");
        this.context.setProgressRange(0L, this.totalLength);
        ArrayList<UpdateTracking> arrayList = new ArrayList<UpdateTracking>();
        HashMap<ModuleUpdate, Object> hashMap = new HashMap<ModuleUpdate, Object>();
        for (File object2 : this.getClustersForInstall()) {
            UpdateTracking updateTracking = UpdateTracking.getTracking(object2, true, this.context);
            if (updateTracking == null) {
                throw new RuntimeException("No update_tracking file in cluster " + object2);
            }
            arrayList.add(updateTracking);
            int entry = 0;
            for (File file : this.getFilesForInstallInCluster(object2)) {
                UpdateTracking.Module module;
                ModuleUpdate moduleUpdate;
                block52: {
                    Object object3;
                    Object object4;
                    ++entry;
                    this.context.unpackingIsRunning();
                    try {
                        moduleUpdate = new ModuleUpdate(file);
                    }
                    catch (RuntimeException runtimeException) {
                        if (!file.exists()) continue;
                        XMLUtil.LOG.info("Deleteing file: " + file);
                        if (!file.delete()) {
                            XMLUtil.LOG.log(Level.WARNING, "File " + file + " cannot be deleted. Propably file lock on the file.");
                            assert (false) : "Error: File " + file + " cannot be deleted. Propably file lock on the file.";
                            file.deleteOnExit();
                            continue;
                        }
                        XMLUtil.LOG.info("File " + file + " deleted.");
                        continue;
                    }
                    assert (moduleUpdate != null) : "Module update is not null for file: " + file;
                    if (moduleUpdate.isL10n()) {
                        module = null;
                        object = updateTracking.createVersion("0");
                        hashMap.put(moduleUpdate, object);
                    } else {
                        module = updateTracking.readModuleTracking(moduleUpdate.getCodenamebase(), true);
                        object4 = UpdateTracking.getAdditionalInformation(object2, this.context);
                        object3 = object4 != null && ((UpdateTracking.AdditionalInfo)object4).getSource(file.getName()) != null ? ((UpdateTracking.AdditionalInfo)object4).getSource(file.getName()) : "updater";
                        object = module.addNewVersion(moduleUpdate.getSpecification_version(), (String)object3);
                    }
                    boolean bl = false;
                    this.context.setLabel(Localization.getBrandedString("CTL_UnpackingFile") + "  " + file.getName());
                    this.context.setProgressValue(l);
                    object4 = null;
                    try {
                        MainConfig mainConfig;
                        Object object5;
                        String string;
                        Serializable serializable;
                        Object object6;
                        String string2;
                        object4 = new JarFile(file);
                        object3 = ((JarFile)object4).entries();
                        Manifest manifest = ((JarFile)object4).getManifest();
                        String string3 = string2 = manifest != null ? ModuleUpdate.extractCodeName(manifest.getMainAttributes()) : null;
                        if (string2 != null) {
                            object6 = file;
                            serializable = new File(object2, "modules/" + ((File)object6).getName());
                            if (((File)serializable).exists()) {
                                File file2 = new File(this.getBackupDirectory(object2), ((File)object6).getName());
                                file2.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream((File)serializable), this.context.createOS(file2), -1L);
                                XMLUtil.LOG.info("Backup file " + serializable + " to " + file2);
                                if (!((File)serializable).delete() && ModuleUpdater.isWindows()) {
                                    ModuleUpdater.trickyDeleteOnWindows((File)serializable);
                                } else {
                                    XMLUtil.LOG.info("File " + serializable + " deleted.");
                                }
                            } else {
                                ((File)serializable).getParentFile().mkdirs();
                            }
                            l = this.copyStreams(new FileInputStream((File)object6), this.context.createOS((File)serializable), l);
                            XMLUtil.LOG.info("Copied file " + object6 + " to " + serializable);
                            long l2 = UpdateTracking.getFileCRC((File)serializable);
                            ((UpdateTracking.Version)object).addFileWithCrc("modules/" + ((File)object6).getName(), Long.toString(l2));
                            this.context.setProgressValue(l);
                            module.setOSGi(true);
                            break block52;
                        }
                        object6 = this.readExecutableFilesList((JarFile)object4);
                        serializable = new ArrayList<File>();
                        while (object3.hasMoreElements()) {
                            JarEntry jarEntry = (JarEntry)object3.nextElement();
                            this.checkStop();
                            if (jarEntry.getName().startsWith(UPDATE_NETBEANS_DIR)) {
                                long l3;
                                File file3;
                                if (jarEntry.isDirectory() || AUTOUPDATE_UPDATER_JAR_PATH.equals(jarEntry.getName()) || jarEntry.toString().matches(AUTOUPDATE_UPDATER_JAR_LOCALE_PATTERN)) continue;
                                string = jarEntry.getName().substring(UPDATE_NETBEANS_DIR.length() + 1);
                                object5 = new File(object2, jarEntry.getName().substring(UPDATE_NETBEANS_DIR.length()));
                                if (((File)object5).exists()) {
                                    File file4 = new File(this.getBackupDirectory(object2), jarEntry.getName());
                                    file4.getParentFile().mkdirs();
                                    this.copyStreams(new FileInputStream((File)object5), this.context.createOS(file4), -1L);
                                    XMLUtil.LOG.info("Backup file " + object5 + " to " + file4);
                                    if (!((File)object5).delete() && ModuleUpdater.isWindows()) {
                                        ModuleUpdater.trickyDeleteOnWindows((File)object5);
                                    } else {
                                        XMLUtil.LOG.info("File " + object5 + " deleted.");
                                    }
                                } else {
                                    ((File)object5).getParentFile().mkdirs();
                                }
                                if (string.endsWith(".external")) {
                                    file3 = new File(((File)object5).getParentFile(), ((File)object5).getName().substring(0, ((File)object5).getName().lastIndexOf(".external")));
                                    InputStream inputStream = ((JarFile)object4).getInputStream(jarEntry);
                                    string = string.substring(0, string.length() - ".external".length());
                                    long l4 = this.externalDownload(inputStream, file);
                                    File file5 = new File(file + "." + Long.toHexString(l4));
                                    FileInputStream fileInputStream = new FileInputStream(file5);
                                    try {
                                        inputStream.close();
                                        OutputStream outputStream = this.context.createOS(file3);
                                        try {
                                            l = this.copyStreams(fileInputStream, outputStream, -1L);
                                            XMLUtil.LOG.info("Copied external file " + file5 + " to " + file3);
                                        }
                                        finally {
                                            outputStream.close();
                                        }
                                    }
                                    finally {
                                        file5.delete();
                                        XMLUtil.LOG.info("File " + file5 + " deleted.");
                                        ((InputStream)fileInputStream).close();
                                    }
                                    l3 = UpdateTracking.getFileCRC(file3);
                                    if (l3 != l4) {
                                        file3.delete();
                                        XMLUtil.LOG.info("File " + file3 + " deleted.");
                                        throw new IOException("Wrong CRC for " + file3);
                                    }
                                } else {
                                    l = this.copyStreams(((JarFile)object4).getInputStream(jarEntry), this.context.createOS((File)object5), l);
                                    XMLUtil.LOG.info("Copied file " + jarEntry + " to " + object5);
                                    l3 = jarEntry.getCrc();
                                }
                                if (object6.contains(string)) {
                                    serializable.add(object5);
                                }
                                if (string.endsWith(".jar.pack.gz") && ((JarFile)object4).getEntry(jarEntry.getName().substring(0, jarEntry.getName().lastIndexOf(".pack.gz"))) == null) {
                                    file3 = new File(((File)object5).getParentFile(), ((File)object5).getName().substring(0, ((File)object5).getName().lastIndexOf(".pack.gz")));
                                    this.unpack200((File)object5, file3);
                                    ((File)object5).delete();
                                    XMLUtil.LOG.info("File " + object5 + " deleted.");
                                    string = string.substring(0, string.length() - ".pack.gz".length());
                                    l3 = UpdateTracking.getFileCRC(file3);
                                }
                                if (moduleUpdate.isL10n()) {
                                    ((UpdateTracking.Version)object).addL10NFileWithCrc(string, Long.toString(l3), moduleUpdate.getSpecification_version());
                                } else {
                                    ((UpdateTracking.Version)object).addFileWithCrc(string, Long.toString(l3));
                                }
                                this.context.setProgressValue(l);
                                continue;
                            }
                            if (!jarEntry.getName().startsWith(UPDATE_MAIN_DIR) || jarEntry.isDirectory()) continue;
                            string = jarEntry.getName().substring(UPDATE_MAIN_DIR.length() + 1);
                            object5 = new File(ModuleUpdater.getMainDirectory(object2), string);
                            if (object6.contains(string)) {
                                serializable.add(object5);
                            }
                            ((File)object5).getParentFile().mkdirs();
                            bl = true;
                            l = this.copyStreams(((JarFile)object4).getInputStream(jarEntry), this.context.createOS((File)object5), l);
                            XMLUtil.LOG.info("Copied file " + jarEntry + " to " + object5);
                            this.context.setProgressValue(l);
                        }
                        this.chmod((List<File>)((Object)serializable));
                        if (bl && (mainConfig = new MainConfig(ModuleUpdater.getMainDirString(object2) + UpdateTracking.FILE_SEPARATOR + JVM_PARAMS_FILE, object2)).isValid()) {
                            string = System.getProperty("java.home") + UpdateTracking.FILE_SEPARATOR + "bin" + UpdateTracking.FILE_SEPARATOR + "java";
                            string = ModuleUpdater.quoteString(string);
                            object5 = string + " -cp " + ModuleUpdater.quoteString(ModuleUpdater.getMainDirString(object2) + mainConfig.getClasspath()) + mainConfig.getCommand();
                            this.startCommand((String)object5);
                            this.deleteDir(ModuleUpdater.getMainDirectory(object2));
                        }
                    }
                    catch (IOException iOException) {
                        XMLUtil.LOG.log(Level.INFO, "Ignore non-readable files ", iOException);
                    }
                    finally {
                        try {
                            if (object4 != null) {
                                ((ZipFile)object4).close();
                            }
                        }
                        catch (IOException iOException) {}
                        if (!file.delete()) {
                            XMLUtil.LOG.log(Level.WARNING, "Error: Cannot delete {0}", file);
                            file.deleteOnExit();
                        } else {
                            XMLUtil.LOG.info("File " + file + " deleted.");
                        }
                    }
                }
                if (moduleUpdate.isL10n()) continue;
                module.write();
                module.writeConfigModuleXMLIfMissing();
            }
            if (entry <= 0) continue;
            UpdaterDispatcher.touchLastModified(object2);
        }
        for (UpdateTracking updateTracking : arrayList) {
            for (Map.Entry entry : hashMap.entrySet()) {
                ModuleUpdate moduleUpdate = (ModuleUpdate)entry.getKey();
                UpdateTracking.Version version = (UpdateTracking.Version)entry.getValue();
                object = updateTracking.readModuleTracking(moduleUpdate.getCodenamebase(), true);
                ((UpdateTracking.Module)object).addL10NVersion(version);
                ((UpdateTracking.Module)object).write();
            }
            updateTracking.deleteUnusedFiles();
        }
    }

    private boolean unpack200(File file, File file2) {
        String string = new File(System.getProperty("java.home"), "bin/unpack200" + (ModuleUpdater.isWindows() ? ".exe" : "")).getAbsolutePath();
        ProcessBuilder processBuilder = new ProcessBuilder(string, file.getAbsolutePath(), file2.getAbsolutePath());
        processBuilder.directory(file.getParentFile());
        int n = 1;
        try {
            Process process = processBuilder.start();
            n = process.waitFor();
            process.destroy();
            XMLUtil.LOG.info("Unpack " + file + " to " + file2);
        }
        catch (IOException iOException) {
            XMLUtil.LOG.log(Level.WARNING, null, iOException);
        }
        catch (InterruptedException interruptedException) {
            XMLUtil.LOG.log(Level.WARNING, null, interruptedException);
        }
        return n == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readExecutableFilesList(JarFile jarFile) {
        ArrayList<String> arrayList = new ArrayList<String>();
        JarEntry jarEntry = jarFile.getJarEntry(EXECUTABLE_FILES_ENTRY);
        if (jarEntry != null) {
            BufferedReader bufferedReader = null;
            try {
                String string;
                bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry), "UTF-8"));
                while ((string = bufferedReader.readLine()) != null) {
                    arrayList.add(string);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                XMLUtil.LOG.log(Level.WARNING, null, exception);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return arrayList;
    }

    private void chmod(List<File> list) {
        if (ModuleUpdater.isWindows() || list.isEmpty()) {
            return;
        }
        for (File file : list) {
            file.setExecutable(true, false);
        }
    }

    public static boolean trickyDeleteOnWindows(File file) {
        assert (ModuleUpdater.isWindows()) : "Call it only on Windows but system is " + System.getProperty("os.name");
        File file2 = new File(file.getParentFile(), file.getName());
        assert (file2.exists()) : "The file " + file2 + " must exists.";
        try {
            File file3 = File.createTempFile(TEMP_FILE_NAME, null, file2.getParentFile());
            if (file3.delete()) {
                file2.renameTo(file3);
                XMLUtil.LOG.info("File " + file2 + " renamed to " + file3);
                file3.deleteOnExit();
                XMLUtil.LOG.info("Locked file " + file3 + " will be deleted on exit.");
            } else {
                XMLUtil.LOG.info("File " + file3 + " was deleted.");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !file2.exists();
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("windows");
    }

    private void startCommand(String string) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process;
            final Process process2 = process = runtime.exec(ModuleUpdater.parseParameters(string));
            new Thread(){

                @Override
                public void run() {
                    try {
                        String string;
                        InputStreamReader inputStreamReader = new InputStreamReader(process2.getErrorStream());
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        do {
                            if ((string = bufferedReader.readLine()) == null) continue;
                            XMLUtil.LOG.info(string);
                        } while (string != null);
                    }
                    catch (Exception exception) {
                        XMLUtil.LOG.log(Level.INFO, null, exception);
                    }
                }
            }.start();
            int n = process.waitFor();
        }
        catch (Exception exception) {
            XMLUtil.LOG.log(Level.INFO, null, exception);
        }
    }

    public File getBackupDirectory(File file) {
        File file2 = new File(file, BACKUP_DIR);
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        return file2;
    }

    private static File getMainDirectory(File file) {
        File file2 = new File(file, UpdateTracking.FILE_SEPARATOR + "update" + UpdateTracking.FILE_SEPARATOR + UPDATE_MAIN_DIR);
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        return file2;
    }

    private static String getMainDirString(File file) {
        return ModuleUpdater.getMainDirectory(file).getPath();
    }

    public static String quoteString(String string) {
        if (string.indexOf(32) > -1) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n = 0;
            while (n < stringBuilder.length()) {
                if (stringBuilder.charAt(n) == '\"') {
                    stringBuilder.deleteCharAt(n);
                    continue;
                }
                ++n;
            }
            stringBuilder.insert(0, '\"');
            stringBuilder.append('\"');
            return stringBuilder.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyStreams(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        byte[] byArray = new byte[8192];
        try {
            int n2;
            while ((n2 = bufferedInputStream.read(byArray)) != -1) {
                bufferedOutputStream.write(byArray, 0, n2);
                if ((n += n2) <= 8500) continue;
                if (l >= 0L) {
                    this.context.setProgressValue(l += (long)n);
                }
                n = 0;
                this.checkStop();
            }
            if (l >= 0L) {
                l += (long)n;
            }
        }
        finally {
            bufferedInputStream.close();
            bufferedOutputStream.close();
            inputStream.close();
            outputStream.close();
        }
        return l;
    }

    private void deleteDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.deleteDir(fileArray[i]);
            }
            if (!fileArray[i].delete()) {
                XMLUtil.LOG.log(Level.WARNING, "Cannot delete {0}", fileArray[i]);
                assert (false) : "Cannot delete " + fileArray[i];
                continue;
            }
            XMLUtil.LOG.info("File " + fileArray[i] + " deleted.");
        }
    }

    private static String[] parseParameters(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        Vector<String> vector = new Vector<String>(5, 5);
        int n6 = n;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n7 = string.length();
        for (int i = 0; i < n7; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (n6 == n) {
                    if (stringBuilder.length() <= 0) continue;
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (n6 == n4) {
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n5) {
                    stringBuilder.append('\\');
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n3) {
                    n6 = n2;
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\\') {
                if (n6 == n) {
                    if (++i < n7) {
                        char c2 = string.charAt(i);
                        if (c2 == '\"' || c2 == '\\') {
                            stringBuilder.append(c2);
                            continue;
                        }
                        if (Character.isWhitespace(c2)) {
                            stringBuilder.append(c);
                            --i;
                            continue;
                        }
                        stringBuilder.append(c);
                        stringBuilder.append(c2);
                        continue;
                    }
                    stringBuilder.append('\\');
                    break;
                }
                if (n6 == n2) {
                    n6 = n3;
                    continue;
                }
                if (n6 == n3) {
                    stringBuilder.append('\\');
                    n6 = n2;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n5;
                    continue;
                }
                if (n6 != n5) continue;
                stringBuilder.append('\\');
                n6 = n4;
                continue;
            }
            if (c == '\"') {
                if (n6 == n) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n2) {
                    n6 = n4;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n5) {
                    stringBuilder.append('\"');
                    n6 = n4;
                    continue;
                }
                stringBuilder.append('\"');
                n6 = n2;
                continue;
            }
            if (n6 == n3) {
                stringBuilder.append('\\');
                n6 = n2;
            } else if (n6 == n5) {
                stringBuilder.append('\\');
                n6 = n4;
            }
            stringBuilder.append(c);
        }
        if (n6 == n2) {
            vector.addElement(stringBuilder.toString());
        } else if ((n6 & (n3 | n5)) != 0) {
            stringBuilder.append('\\');
            vector.addElement(stringBuilder.toString());
        } else if (stringBuilder.length() != 0) {
            vector.addElement(stringBuilder.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private long externalDownload(InputStream inputStream, File file) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        do {
            if ((string = bufferedReader.readLine()) != null) continue;
            throw new IOException("No CRC in the .external file!");
        } while (!string.startsWith("CRC:"));
        return Long.parseLong(string.substring(4).trim());
    }

    public static Set<File> getModulesToInstall(File file) {
        File file2 = new File(file, DOWNLOAD_DIR);
        class NbmFilter
        implements FilenameFilter {
            NbmFilter() {
            }

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(ModuleUpdater.NBM_EXTENSION) || string.endsWith(ModuleUpdater.JAR_EXTENSION);
            }
        }
        File[] fileArray = file2.listFiles(new NbmFilter());
        if (fileArray == null) {
            return Collections.emptySet();
        }
        return new HashSet<File>(Arrays.asList(fileArray));
    }

    static class MainConfig {
        private final String PAR_MAIN = "mainClass";
        private final String PAR_RELCP = "relativeClassPath";
        private final String PAR_JVMPAR = "jvm.parameters";
        private final String PAR_MAINARGS = "mainClass.arguments";
        private final String VAR_IDE_HOME = "%IDE_HOME%";
        private final String VAR_IDE_USER = "%IDE_USER%";
        private final String VAR_FILE_SEPARATOR = "%FS%";
        private final String VAR_PATH_SEPARATOR = "%PS%";
        private final String VAR_JAVA_HOME = "%JAVA_HOME%";
        private String parameters = "";
        private String classpath = "";
        private boolean valid = false;
        private final File activeCluster;

        public MainConfig(String string, File file) {
            this.valid = this.readParms(string);
            this.activeCluster = file;
        }

        public String getCommand() {
            return this.parameters;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readParms(String string) {
            String string2;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String string3 = properties.getProperty("relativeClassPath", null);
            if (string3 != null) {
                string3 = this.replaceVars(string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, UpdateTracking.PATH_SEPARATOR, false);
                while (stringTokenizer.hasMoreTokens()) {
                    this.classpath = this.classpath + UpdateTracking.PATH_SEPARATOR + this.changeRelative(stringTokenizer.nextToken());
                }
            }
            this.parameters = "";
            String string4 = properties.getProperty("jvm.parameters", null);
            if (string4 != null) {
                this.parameters = this.parameters + " " + string4;
            }
            if ((string2 = properties.getProperty("mainClass", null)) == null) {
                return false;
            }
            this.parameters = this.parameters + " " + string2;
            String string5 = properties.getProperty("mainClass.arguments", null);
            if (string5 != null) {
                this.parameters = this.parameters + " " + string5;
            }
            this.parameters = this.replaceVars(this.parameters);
            return true;
        }

        private String replaceVars(String string) {
            string = this.replaceAll(string, "%IDE_HOME%", UpdateTracking.getPlatformDir() == null ? "" : UpdateTracking.getPlatformDir().getPath());
            string = this.replaceAll(string, "%IDE_USER%", UpdateTracking.getUserDir() == null ? "" : UpdateTracking.getUserDir().getPath());
            string = this.replaceAll(string, "%FS%", UpdateTracking.FILE_SEPARATOR);
            string = this.replaceAll(string, "%PS%", UpdateTracking.PATH_SEPARATOR);
            string = this.replaceAll(string, "%JAVA_HOME%", System.getProperty("java.home"));
            return string;
        }

        private String changeRelative(String string) {
            if (new File(string).isAbsolute()) {
                return string;
            }
            return ModuleUpdater.getMainDirString(this.activeCluster) + UpdateTracking.FILE_SEPARATOR + string;
        }

        private String replaceAll(String string, String string2, String string3) {
            StringBuilder stringBuilder = new StringBuilder(string);
            int n = stringBuilder.toString().indexOf(string2);
            int n2 = string2.length();
            while (n > -1) {
                stringBuilder.replace(n, n + n2, string3);
                n = stringBuilder.toString().indexOf(string2, n + 1);
            }
            return stringBuilder.toString();
        }
    }
}

