/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import java.net.MalformedURLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

public class ConnectionToolkit {
    private ConnectionToolkit() {
    }

    public static String getHostName(JMXServiceURL url) {
        if (url.getHost() == null || "".equals(url.getHost().trim())) {
            return ConnectionToolkit.deriveHost(url);
        }
        return url.getHost();
    }

    public static int getPort(JMXServiceURL url) {
        if (url.getPort() <= 0) {
            return ConnectionToolkit.derivePort(url);
        }
        return url.getPort();
    }

    private static String deriveHost(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            int i = 0;
            while (i < 2) {
                st.nextToken();
                ++i;
            }
            String host = st.nextToken();
            return host;
        }
        return "unknown";
    }

    private static int derivePort(JMXServiceURL url) {
        StringTokenizer st = new StringTokenizer(url.getURLPath(), ":/");
        if (st.countTokens() == 5) {
            int i = 0;
            while (i < 3) {
                st.nextToken();
                ++i;
            }
            String port = st.nextToken();
            try {
                return Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return 0;
    }

    public static JMXServiceURL createServiceURL(String host, int port) throws MalformedURLException {
        int actualPort = port != -1 ? port : 7091;
        return new JMXServiceURL("rmi", "", 0, "/jndi/rmi://" + host + ':' + actualPort + "/jmxrmi");
    }

    public static int getDefaultPort() {
        return 7091;
    }

    public static boolean isJRockit(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return ConnectionToolkit.isJRockitJVMName(vmName);
    }

    public static boolean isHotSpot(IConnectionHandle connectionHandle) {
        String vmName = ConnectionToolkit.getVMName(connectionHandle);
        return vmName != null && ConnectionToolkit.isHotspotJVMName(vmName);
    }

    public static boolean isJRockitJVMName(String vmName) {
        if (vmName == null) {
            return false;
        }
        return vmName.startsWith("BEA JRockit") || vmName.startsWith("Oracle JRockit");
    }

    public static boolean isHotspotJVMName(String vmName) {
        if (vmName == null) {
            return false;
        }
        return vmName.startsWith("Java HotSpot") || vmName.startsWith("OpenJDK");
    }

    public static boolean isJDKVersionAboveOrEqual(String JdkVersion, float minVersion) {
        return ConnectionToolkit.isVersionAboveOrEqual(JdkVersion, minVersion);
    }

    public static boolean isHotspotVersionAboveOrEqual(IConnectionHandle connectionHandle, float minVersion) {
        String version = ConnectionToolkit.getVMVersion(connectionHandle);
        return ConnectionToolkit.isHotspotVersionAboveOrEqual(version, minVersion);
    }

    public static boolean isHotspotVersionAboveOrEqual(String vmVersion, float minVersion) {
        return ConnectionToolkit.isVersionAboveOrEqual(vmVersion, minVersion);
    }

    private static boolean isVersionAboveOrEqual(String version, float minVersion) {
        if (version == null) {
            return false;
        }
        String versionString = version;
        versionString = ConnectionToolkit.cutAfterChar(versionString, '-');
        versionString = ConnectionToolkit.cutAfterChar(versionString, '_');
        float v = Float.parseFloat(versionString = ConnectionToolkit.stripButOnePoint(versionString));
        return v >= minVersion;
    }

    private static String cutAfterChar(String versionString, char ch) {
        if (versionString.indexOf(ch) >= 0) {
            return versionString.substring(0, versionString.indexOf(ch));
        }
        return versionString;
    }

    private static String stripButOnePoint(String versionString) {
        int firstIndex = versionString.indexOf(46);
        int lastIndex = versionString.lastIndexOf(46);
        if (firstIndex >= 0 && lastIndex >= 0 && firstIndex != lastIndex) {
            return versionString.substring(0, versionString.indexOf(46, firstIndex + 1));
        }
        return versionString;
    }

    private static String getVMVersion(IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            return connection.getAttribute(new ObjectName("java.lang:type=Runtime"), "VmVersion").toString();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not check the JVM version!", e);
            return null;
        }
    }

    private static String getVMName(IConnectionHandle connectionHandle) {
        MBeanServerConnection connection = connectionHandle.getServiceOrDummy(MBeanServerConnection.class);
        try {
            return connection.getAttribute(new ObjectName("java.lang:type=Runtime"), "VmName").toString();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not check the JVM name!", e);
            return null;
        }
    }
}

