/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx;

import com.jrockit.mc.common.Callback;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionDescriptor;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerDescriptor;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.ServerDescriptor;
import com.jrockit.mc.rjmx.internal.DefaultConnectionHandle;
import com.jrockit.mc.rjmx.internal.RJMXConnection;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class ServerHandle
implements IServerHandle {
    private final List<DefaultConnectionHandle> connectionHandles = new ArrayList<DefaultConnectionHandle>();
    private final RJMXConnection connection;
    private Runnable observer;
    private Boolean disposedGracefully;
    private final Runnable connectionListener = new Runnable(){

        @Override
        public void run() {
            ServerHandle.this.disconnect();
        }
    };
    private final Callback<IConnectionHandle> connectionHandleListener = new Callback<IConnectionHandle>(){

        public void call(IConnectionHandle handle) throws Exception {
            if (!handle.isConnected() && ServerHandle.this.removeConnectionHandle(handle)) {
                ServerHandle.this.nofifyObserver();
            }
        }
    };

    public ServerHandle(IConnectionDescriptor descriptor) {
        this(new ServerDescriptor(), descriptor, null);
    }

    public ServerHandle(IServerDescriptor server, IConnectionDescriptor descriptor, Runnable observer) {
        this.observer = observer;
        this.connection = new RJMXConnection(descriptor, server, this.connectionListener);
    }

    public IConnectionDescriptor getConnectionDescriptor() {
        return this.connection.getConnectionDescriptor();
    }

    @Override
    public IServerDescriptor getServerDescriptor() {
        return this.connection.getServerDescriptor();
    }

    public synchronized IConnectionHandle[] getConnectionHandles() {
        IConnectionHandle[] handles = new IConnectionHandle[this.connectionHandles.size()];
        Iterator<DefaultConnectionHandle> it = this.connectionHandles.iterator();
        int i = 0;
        while (i < handles.length) {
            handles[i] = it.next();
            ++i;
        }
        return handles;
    }

    @Override
    public IConnectionHandle connect(String usage) throws ConnectionException {
        return this.doConnect(usage, this.connectionHandleListener);
    }

    @Override
    public IConnectionHandle connect(String usage, Callback<? super IConnectionHandle> listener) throws ConnectionException {
        return this.doConnect(usage, listener, this.connectionHandleListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IConnectionHandle doConnect(String usage, Callback<IConnectionHandle> ... listeners) throws ConnectionException {
        DefaultConnectionHandle newConnectionHandle;
        boolean performedConnect;
        ServerHandle serverHandle = this;
        synchronized (serverHandle) {
            if (this.isDisposed()) {
                throw new ConnectionException("Server handle is disposed");
            }
            performedConnect = this.connection.connect();
            newConnectionHandle = new DefaultConnectionHandle(this.connection, usage, listeners);
            this.connectionHandles.add(newConnectionHandle);
        }
        if (performedConnect) {
            this.nofifyObserver();
        }
        return newConnectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(boolean gracefully) {
        ServerHandle serverHandle = this;
        synchronized (serverHandle) {
            if (!this.isDisposed()) {
                this.disposedGracefully = gracefully;
            }
        }
        this.disconnect();
    }

    private synchronized boolean isDisposed() {
        return this.disposedGracefully != null;
    }

    private synchronized boolean removeConnectionHandle(IConnectionHandle handle) {
        this.connectionHandles.remove(handle);
        if (this.connectionHandles.size() == 0) {
            this.connection.close();
            return true;
        }
        return false;
    }

    private void disconnect() {
        IConnectionHandle[] iConnectionHandleArray = this.getConnectionHandles();
        int n = iConnectionHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectionHandle handle = iConnectionHandleArray[n2];
            IOToolkit.closeSilently((Closeable)handle);
            ++n2;
        }
    }

    public String toString() {
        return this.connection.toString();
    }

    private void nofifyObserver() {
        if (this.observer != null) {
            this.observer.run();
        }
    }

    @Override
    public synchronized IServerHandle.State getState() {
        if (this.isDisposed()) {
            return this.disposedGracefully != false ? IServerHandle.State.DISPOSED : IServerHandle.State.FAILED;
        }
        return this.connection.isConnected() ? IServerHandle.State.CONNECTED : IServerHandle.State.DISCONNECTED;
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

