/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx;

import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.ConnectionToolkit;
import com.jrockit.mc.rjmx.Messages;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.management.remote.JMXServiceURL;
import javax.naming.NameNotFoundException;
import javax.naming.NoInitialContextException;
import org.eclipse.osgi.util.NLS;

public class WrappedConnectionException
extends ConnectionException {
    private final String serverName;
    private final JMXServiceURL url;

    public WrappedConnectionException(String serverName, JMXServiceURL url, Exception cause) {
        super(cause.getMessage());
        this.initCause(cause);
        this.url = url;
        this.serverName = serverName;
    }

    @Override
    public String getLocalizedMessage() {
        Throwable cause;
        Throwable rootCause = cause = this.getCause();
        while (rootCause.getCause() != null) {
            rootCause = rootCause.getCause();
        }
        if (rootCause instanceof UnknownHostException) {
            return NLS.bind((String)Messages.ConnectionException_COULD_NOT_DETERMINE_IP_MSG, (Object)ConnectionToolkit.getHostName(this.url));
        }
        if (rootCause instanceof NameNotFoundException) {
            return NLS.bind((String)Messages.ConnectionException_NAME_NOT_FOUND_MSG, (Object)this.url);
        }
        if (rootCause instanceof MalformedURLException) {
            return NLS.bind((String)Messages.ConnectionException_MALFORMED_URL_MSG, (Object)this.url);
        }
        if (rootCause instanceof NoInitialContextException) {
            return NLS.bind((String)Messages.ConnectionException_UNABLE_TO_CREATE_INITIAL_CONTEXT, (Object)this.url);
        }
        if (this.url.getProtocol().equals("msarmi")) {
            return NLS.bind((String)Messages.ConnectionException_MSARMI_CHECK_PASSWORD, (Object)this.url);
        }
        if (rootCause instanceof SecurityException || rootCause instanceof GeneralSecurityException) {
            return NLS.bind((String)Messages.ConnectionException_UNABLE_TO_RESOLVE_CREDENTIALS, (Object)rootCause.getLocalizedMessage());
        }
        if ("com.sun.tools.attach.AttachNotSupportedException".equals(rootCause.getClass().getName())) {
            return NLS.bind((String)Messages.ConnectionException_ATTACH_NOT_SUPPORTED, (Object)this.serverName, (Object)rootCause.getLocalizedMessage());
        }
        return NLS.bind((String)Messages.ConnectionException_COULD_NOT_CONNECT_MSG, (Object)this.url);
    }

    @Override
    public String toString() {
        return String.valueOf(ConnectionException.class.getName()) + " caused by " + this.getCause().toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }
}

