/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.actionprovider;

import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.common.IUserAction;
import com.jrockit.mc.common.util.IImageResource;
import com.jrockit.mc.common.util.Resource;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.actionprovider.ActionProvider;
import com.jrockit.mc.rjmx.actionprovider.IDoubleClickable;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;

class ActionProviderDescriptor
extends ActionProvider
implements IDescribable,
IImageResource,
IDoubleClickable {
    private IConfigurationElement element;
    private Resource imageResource;

    public ActionProviderDescriptor(IConfigurationElement element) throws Exception {
        this.element = element;
        this.imageResource = new Resource(element.getDeclaringExtension().getContributor().getName(), element.getAttribute("icon"));
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public Resource getImageResource() {
        return this.imageResource;
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        return this.element.getAttribute("label");
    }

    public String toString() {
        return "label= " + this.getName() + " | " + this.getActions();
    }

    @Override
    public IUserAction getDoubleClickAction() {
        String attribute = this.element.getAttribute("doubleClickActionIndex");
        if (attribute != null) {
            try {
                Integer doubleClickActionIndex = Integer.parseInt(attribute);
                return (IUserAction)this.getActions().get(doubleClickActionIndex);
            }
            catch (NumberFormatException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "Could not parse doubleClickActionIndex", e);
            }
        }
        return null;
    }
}

