/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.internal;

import com.jrockit.mc.common.Callback;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerDescriptor;
import com.jrockit.mc.rjmx.internal.IDisposableService;
import com.jrockit.mc.rjmx.internal.MBeanServerChangeListenerCollection;
import com.jrockit.mc.rjmx.internal.RJMXConnection;
import com.jrockit.mc.rjmx.internal.TimestampHolder;
import com.jrockit.mc.rjmx.services.ConnectionClosedException;
import com.jrockit.mc.rjmx.services.CouldNotCreateServiceException;
import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.services.ServiceNotAvailableException;
import com.jrockit.mc.rjmx.services.internal.MBeanOperationsWrapper;
import com.jrockit.mc.rjmx.services.internal.ServiceFactoryManager;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMBeanServerChangeListener;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;

public class DefaultConnectionHandle
implements IConnectionHandle,
IMBeanHelperService {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final Map<Class<?>, Object> services = Collections.synchronizedMap(new LinkedHashMap());
    private long localStartTime = -1L;
    private final String description;
    private final RJMXConnection connection;
    private final Callback<? super IConnectionHandle>[] listeners;
    private final MBeanServerChangeListenerCollection m_notificationListeners;
    private static final ServiceFactoryManager FACTORY_MANAGER = new ServiceFactoryManager();
    private volatile Long closeDownThreadId;

    public DefaultConnectionHandle(RJMXConnection connection, String description, Callback<? super IConnectionHandle> ... listeners) {
        this.connection = connection;
        this.description = description;
        this.listeners = listeners;
        this.m_notificationListeners = new MBeanServerChangeListenerCollection(connection, LOGGER);
        this.setLocalStartTime(System.currentTimeMillis());
        this.registerDefaultServices();
    }

    @Override
    public IServerDescriptor getServerDescriptor() {
        return this.connection.getServerDescriptor();
    }

    @Override
    public boolean isConnected() {
        return this.isOpen() && this.connection.isConnected();
    }

    private boolean isOpen() {
        return this.closeDownThreadId == null || Thread.currentThread().getId() == this.closeDownThreadId.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            if (this.closeDownThreadId != null) {
                return;
            }
            this.closeDownThreadId = Thread.currentThread().getId();
            this.shutdownServices();
            this.closeDownThreadId = -1L;
        }
        Callback<? super IConnectionHandle>[] callbackArray = this.listeners;
        int n = this.listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Callback<? super IConnectionHandle> l = callbackArray[n2];
            try {
                l.call((Object)this);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "DefaultConnectionHandle listener " + l + " failed", e);
            }
            ++n2;
        }
    }

    @Override
    public long getLocalStartTime() {
        return this.localStartTime;
    }

    private void shutdownServices() {
        Object[] servicesArray = this.services.values().toArray();
        int i = 0;
        while (i < servicesArray.length) {
            Object service = servicesArray[servicesArray.length - i - 1];
            if (service instanceof IDisposableService) {
                try {
                    ((IDisposableService)service).dispose();
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Could not shut down the " + service.getClass().getName() + " service.", e);
                }
            }
            ++i;
        }
        this.cleanUpNotifications();
        this.services.clear();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private void setLocalStartTime(long startTime) {
        this.localStartTime = startTime;
    }

    @Override
    public Set<ObjectName> getMBeanNames() throws IOException {
        return this.connection.getMBeanNames();
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName mbean) throws IOException {
        try {
            return this.connection.getMBeanInfo(mbean);
        }
        catch (JMException e) {
            return null;
        }
    }

    @Override
    public Collection<IOperation> getOperations(ObjectName mbean) throws Exception {
        MBeanServerConnection srv;
        MBeanOperationInfo[] info;
        block2: {
            info = null;
            srv = this.connection.getMBeanServer();
            try {
                info = srv.getMBeanInfo(mbean).getOperations();
            }
            catch (InstanceNotFoundException e) {
                if (this.connection.getMBeanInfo(mbean) == null) break block2;
                throw e;
            }
        }
        return new MBeanOperationsWrapper(mbean, info == null ? new MBeanOperationInfo[]{} : info, srv);
    }

    @Override
    public long getRemoteStartTime() {
        if (!this.connection.isConnected()) {
            return -1L;
        }
        return this.connection.getRemoteStartTime();
    }

    @Override
    public List<MRIValue> getAttributes(Iterable<MRI> attributes) throws IOException, InstanceNotFoundException, ReflectionException, MBeanException {
        TimestampHolder timestamp = new TimestampHolder();
        if (attributes == null) {
            throw new IllegalArgumentException("Can't fetch anything! attributes == null!");
        }
        ArrayList<MRIValue> results = new ArrayList<MRIValue>();
        Map<MRI, Object> values = this.connection.getAttributes(attributes, timestamp);
        for (Map.Entry<MRI, Object> entry : values.entrySet()) {
            results.add(new MRIValue(entry.getKey(), entry.getValue(), timestamp.timestamp));
        }
        return results;
    }

    private void checkType(MRI.Type actual, MRI.Type expected) {
        if (actual != expected) {
            throw new IllegalArgumentException("The type of the MRI must be " + (Object)((Object)expected) + '!');
        }
    }

    @Override
    public MRIValue getAttribute(MRI attributeDescriptor) throws OperationsException, MBeanException, IOException, ReflectionException {
        this.checkType(attributeDescriptor.getType(), MRI.Type.ATTRIBUTE);
        long startTime = System.currentTimeMillis();
        Object attr = this.connection.getAttribute(attributeDescriptor);
        if (attr == null) {
            return null;
        }
        MRIValue tmpData = new MRIValue(attributeDescriptor, attr, this.connection.getApproximateServerTime(startTime));
        return tmpData;
    }

    @Override
    public void setAttribute(MRI attribute, Object data) throws OperationsException, InvalidAttributeValueException, MBeanException, IOException, ReflectionException {
        this.checkType(attribute.getType(), MRI.Type.ATTRIBUTE);
        this.connection.setAttribute(attribute, data);
    }

    public String toString() {
        return String.valueOf(this.description) + " - " + this.connection.toString();
    }

    @Override
    public long getApproximateServerTime(long localTime) {
        return this.connection.getApproximateServerTime(localTime);
    }

    @Override
    public <T> T getServiceOrThrow(Class<T> serviceInterface) throws ConnectionClosedException, ServiceNotAvailableException {
        if (this.isOpen()) {
            T service = this.getService(serviceInterface, false);
            if (service != null) {
                return service;
            }
        } else {
            throw new ConnectionClosedException();
        }
        throw new ServiceNotAvailableException();
    }

    @Override
    public <T> T getServiceOrDummy(Class<T> serviceInterface) {
        if (!serviceInterface.isInterface()) {
            throw new IllegalArgumentException("Will not be able to create dummy implementations of " + serviceInterface.getName() + " since the service is not an interface");
        }
        if (this.isOpen()) {
            return this.getService(serviceInterface, true);
        }
        return DefaultConnectionHandle.createDummyService(serviceInterface);
    }

    @Override
    public <T> T getServiceOrNull(Class<T> serviceInterface) {
        if (this.isOpen()) {
            return this.getService(serviceInterface, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getService(Class<T> serviceInterface, boolean acceptDummy) {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            Object service = this.services.get(serviceInterface);
            if (service == null) {
                service = FACTORY_MANAGER.createService(serviceInterface, this);
                if (service == null && acceptDummy) {
                    service = DefaultConnectionHandle.createDummyService(serviceInterface);
                }
                if (service != null) {
                    this.services.put(serviceInterface, service);
                }
            }
            return (T)(acceptDummy || !ServiceFactoryManager.isDummy(service) ? service : null);
        }
    }

    private static <T> T createDummyService(Class<T> serviceInterface) {
        try {
            return ServiceFactoryManager.createDummyService(serviceInterface, null);
        }
        catch (IllegalArgumentException e) {
            throw new CouldNotCreateServiceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void registerDefaultServices() {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            this.services.put(MBeanServerConnection.class, this.connection.getMBeanServer());
            this.services.put(DefaultConnectionHandle.class, this);
            this.services.put(IMBeanHelperService.class, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasService(Class<?> serviceClass) {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            return this.getServiceOrNull(serviceClass) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean registerService(Class<T> serviceClass, T serviceObject) {
        if (serviceObject == null) {
            throw new IllegalArgumentException("You can not add a null service!");
        }
        if (!serviceClass.isAssignableFrom(serviceObject.getClass())) {
            throw new IllegalArgumentException(String.valueOf(serviceObject.toString()) + " does not implement " + serviceClass.getName());
        }
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            block6: {
                if (!this.hasService(serviceClass)) break block6;
                return false;
            }
            this.services.put(serviceClass, serviceObject);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T unregisterService(Class<T> clazz) {
        Map<Class<?>, Object> map = this.services;
        synchronized (map) {
            Object service = this.services.get(clazz);
            if (service instanceof IDisposableService) {
                ((IDisposableService)service).dispose();
            }
            Object remove = this.services.remove(clazz);
            return (T)remove;
        }
    }

    @Override
    public void clearCache() {
        this.connection.clearCache();
    }

    @Override
    public Map<ObjectName, MBeanInfo> getMBeanInfos() throws IOException {
        return this.connection.getMBeanInfos();
    }

    private void cleanUpNotifications() {
        this.m_notificationListeners.cleanUpNotifications();
    }

    @Override
    public void removeMBeanServerChangeListener(IMBeanServerChangeListener listener) {
        this.m_notificationListeners.removeMBeanServerChangeListener(listener);
    }

    @Override
    public void addMBeanServerChangeListener(IMBeanServerChangeListener callback) {
        this.m_notificationListeners.addMBeanServerChangeListener(callback);
    }

    @Override
    public Object invokeMethod(ObjectName beanName, String methodName) throws IOException, UndeclaredThrowableException {
        return this.invokeMethod(beanName, methodName, EMPTY_OBJECT_ARRAY, EMPTY_STRING_ARRAY);
    }

    @Override
    public Object invokeMethod(ObjectName beanName, String methodName, Object[] param, String[] sig) throws IOException, UndeclaredThrowableException {
        try {
            return this.invokeMethodWithException(beanName, methodName, param, sig);
        }
        catch (MBeanException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public Object invokeMethodWithException(ObjectName beanName, String methodName, Object[] param, String[] sig) throws IOException, MBeanException, UndeclaredThrowableException {
        try {
            return this.connection.getMBeanServer().invoke(beanName, methodName, param, sig);
        }
        catch (InstanceNotFoundException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (ReflectionException e) {
            throw new UndeclaredThrowableException(e);
        }
        catch (UnsupportedClassVersionError e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            assert (false);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException, MBeanException, IOException {
        return this.connection.createMBean(className, name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

