/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.internal;

import com.jrockit.mc.rjmx.IPropertySyntheticAttribute;
import com.jrockit.mc.rjmx.ISyntheticAttribute;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.SyntheticAttributeEntry;
import com.jrockit.mc.rjmx.internal.SyntheticAttributeMBeanEntry;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class SyntheticAttributeRepository {
    private final Map<ObjectName, SyntheticAttributeMBeanEntry> mbeans = new HashMap<ObjectName, SyntheticAttributeMBeanEntry>();
    private final MBeanServer server = MBeanServerFactory.newMBeanServer();
    private final MBeanServerConnection compoundServer;

    public SyntheticAttributeRepository(MBeanServerConnection compoundServer) {
        this.compoundServer = compoundServer;
    }

    void initializeFromExtensions() {
        IExtension[] extensions;
        IExtensionRegistry er = Platform.getExtensionRegistry();
        IExtensionPoint ep = er.getExtensionPoint("com.jrockit.mc.rjmx.syntheticattribute");
        IExtension[] iExtensionArray = extensions = ep.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = extension.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                if (config.getName().equals("syntheticAttribute")) {
                    try {
                        ISyntheticAttribute attribute = (ISyntheticAttribute)config.createExecutableExtension("class");
                        SyntheticAttributeEntry entry = this.createEntry(attribute, config);
                        this.registerEntry(entry);
                    }
                    catch (CoreException e) {
                        RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not instantiate synthetic attribute!", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void registerEntry(SyntheticAttributeEntry attributeEntry) {
        ObjectName objectName = attributeEntry.getAttributeDescriptor().getObjectName();
        SyntheticAttributeMBeanEntry entry = this.mbeans.get(objectName);
        if (entry == null) {
            entry = new SyntheticAttributeMBeanEntry(this.compoundServer);
            try {
                this.server.registerMBean(entry, objectName);
                this.mbeans.put(objectName, entry);
            }
            catch (Exception e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not register MBean for synthetic attribute!", e);
            }
        }
        entry.addSyntheticAttribute(attributeEntry);
    }

    private SyntheticAttributeEntry createEntry(ISyntheticAttribute attribute, IConfigurationElement config) {
        String attributeName = config.getAttribute("attributeName");
        String description = config.getAttribute("description");
        String type = config.getAttribute("type");
        boolean readable = Boolean.valueOf(config.getAttribute("readable"));
        boolean writeable = Boolean.valueOf(config.getAttribute("writeable"));
        boolean isIs = Boolean.valueOf(config.getAttribute("isIs"));
        if (attribute instanceof IPropertySyntheticAttribute) {
            Map<String, Object> properties = this.parseProperties(config.getChildren("properties"));
            ((IPropertySyntheticAttribute)attribute).setProperties(properties);
        }
        MRI descriptor = MRI.createFromQualifiedName(attributeName);
        return new SyntheticAttributeEntry(attribute, descriptor, description, type, readable, writeable, isIs);
    }

    private Map<String, Object> parseProperties(IConfigurationElement[] children) {
        if (children == null || children.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        IConfigurationElement[] iConfigurationElementArray = children[0].getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.parseProperty(child, properties);
            ++n2;
        }
        return properties;
    }

    private void parseProperty(IConfigurationElement child, Map<String, Object> properties) {
        String key = child.getAttribute("key");
        try {
            if ("string".equals(child.getName())) {
                properties.put(key, child.getAttribute("value"));
            } else if ("boolean".equals(child.getName())) {
                properties.put(key, Boolean.valueOf(child.getAttribute("value")));
            } else if ("integer".equals(child.getName())) {
                properties.put(key, Integer.parseInt(child.getAttribute("value")));
            } else if ("float".equals(child.getName())) {
                properties.put(key, Float.valueOf(Float.parseFloat(child.getAttribute("value"))));
            }
        }
        catch (NumberFormatException e) {
            properties.put(key, e.getMessage());
        }
    }

    public String[] getDomains() {
        return this.server.getDomains();
    }

    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException {
        return this.server.getObjectInstance(name);
    }

    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) {
        return this.server.queryMBeans(name, query);
    }

    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) {
        return this.server.queryNames(name, query);
    }

    public boolean isRegistered(ObjectName name) {
        return this.server.isRegistered(name);
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public boolean hasAttribute(ObjectName name, String dataPath) {
        SyntheticAttributeMBeanEntry entry = this.mbeans.get(name);
        if (entry == null) {
            return false;
        }
        return entry.hasDataPath(dataPath);
    }

    public MBeanInfo getMBeanInfo(ObjectName name) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        return this.server.getMBeanInfo(name);
    }

    public Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        return AttributeValueToolkit.getAttribute(this.server, name, attribute);
    }

    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return AttributeValueToolkit.getAttributes(this.server, name, Arrays.asList(attributes));
    }

    public AttributeList getExistingAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        ArrayList<String> syntheticAttributes = new ArrayList<String>();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (this.hasAttribute(name, attribute)) {
                syntheticAttributes.add(attribute);
            }
            ++n2;
        }
        if (syntheticAttributes.size() > 0) {
            return AttributeValueToolkit.getAttributes(this.server, name, syntheticAttributes);
        }
        return new AttributeList();
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, InvalidAttributeValueException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        AttributeValueToolkit.setAttribute((MBeanServerConnection)this.server, name, attribute);
    }

    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        return AttributeValueToolkit.setAttributes(this.server, name, attributes);
    }

    public AttributeList setExistingAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
        AttributeList existingAttributes = new AttributeList();
        for (Object obj : attributes) {
            Attribute attribute = (Attribute)obj;
            if (!this.hasAttribute(name, attribute.getName())) continue;
            existingAttributes.add(attribute);
        }
        if (existingAttributes.size() > 0) {
            return AttributeValueToolkit.setAttributes(this.server, name, existingAttributes);
        }
        return new AttributeList();
    }

    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException {
        return this.server.isInstanceOf(name, className);
    }

    public void dispose() {
    }
}

