/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.rjmx.persistence.internal.LogFileHeader;
import com.jrockit.mc.rjmx.persistence.internal.PersistedEvent;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeSerializationToolkit;
import com.jrockit.mc.rjmx.util.internal.DefaultRJMXClassFactory;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.GZIPInputStream;

public class LogFileReader {
    private static HashMap<String, Class<?>> primitiveNamesToNumberClasses = new HashMap();
    private LineNumberReader reader;
    private final FileInputStream fileInputStream;
    private final LogFileHeaderImpl headerData;

    static {
        primitiveNamesToNumberClasses.put(Integer.TYPE.getName(), Integer.class);
        primitiveNamesToNumberClasses.put(Byte.TYPE.getName(), Byte.class);
        primitiveNamesToNumberClasses.put(Character.TYPE.getName(), Character.class);
        primitiveNamesToNumberClasses.put(Short.TYPE.getName(), Short.class);
        primitiveNamesToNumberClasses.put(Long.TYPE.getName(), Long.class);
        primitiveNamesToNumberClasses.put(Float.TYPE.getName(), Float.class);
        primitiveNamesToNumberClasses.put(Double.TYPE.getName(), Double.class);
    }

    public LogFileReader(File logFile) throws IOException {
        this.fileInputStream = new FileInputStream(logFile);
        this.headerData = new LogFileHeaderImpl(this.readHeader());
    }

    private LineNumberReader getReader() throws IOException, EOFException {
        if (this.reader == null) {
            this.reader = new LineNumberReader(new InputStreamReader(new GZIPInputStream((InputStream)this.fileInputStream, 8192)));
        }
        return this.reader;
    }

    public PersistedEvent readNextEvent() throws IOException {
        try {
            String line;
            while ((line = this.getReader().readLine()) != null) {
                if (!line.trim().startsWith("<value")) continue;
                String id = this.parseXmlAttributeValue("id", line);
                if (!this.headerData.getIdsToAttributes().containsKey(id)) continue;
                return this.parseEvent(id, line);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    private PersistedEvent parseEvent(String id, String line) throws IOException {
        MRI attributeDescriptor = (MRI)this.headerData.getIdsToAttributes().get(id);
        String timestamp = this.parseXmlAttributeValue("time", line);
        if (id == null || timestamp == null) {
            return null;
        }
        String isNull = this.parseXmlAttributeValue("isNull", line);
        if (isNull != null && isNull.equals(Boolean.TRUE.toString())) {
            return new PersistedEvent(attributeDescriptor, Long.parseLong(timestamp), null);
        }
        String[] valueString = null;
        try {
            valueString = this.parseXmlTagValues("value", line);
        }
        catch (IOException e) {
            return null;
        }
        if (valueString.length > 1) {
            throw new IOException("Line contained multiple XML elements of type: value");
        }
        Class storageClass = (Class)this.headerData.getIdsToStorageClasses().get(id);
        Number value = AttributeSerializationToolkit.deserializeFromString(valueString[0], storageClass);
        return new PersistedEvent(attributeDescriptor, Long.parseLong(timestamp), value);
    }

    private String readHeader() throws IOException {
        StringBuffer headerBuffer = new StringBuffer();
        boolean headerStarted = false;
        try {
            String line;
            while ((line = this.getReader().readLine()) != null) {
                if (headerStarted) {
                    headerBuffer.append(line);
                    if (line.indexOf("</header>") < 0) continue;
                    return headerBuffer.toString();
                }
                if (line.indexOf("<header>") < 0) continue;
                headerStarted = true;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return null;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.fileInputStream != null) {
            this.fileInputStream.close();
        }
    }

    private String parseXmlAttributeValue(String attributeName, String stringToParse) {
        int n = stringToParse.indexOf(attributeName);
        if (n > 0) {
            int firstQuote = stringToParse.indexOf(34, n);
            int secondQuote = stringToParse.indexOf(34, firstQuote + 1);
            if (firstQuote >= 0 && secondQuote >= 0) {
                return stringToParse.substring(firstQuote + 1, secondQuote);
            }
        }
        return null;
    }

    private String[] parseXmlTagValues(String elementName, String stringToParse) throws IOException {
        ArrayList<String> values = new ArrayList<String>();
        String startTag = String.valueOf('<') + elementName;
        String endTag = "</" + elementName + '>';
        int n = -1;
        while ((n = stringToParse.indexOf(startTag, n + 1)) >= 0) {
            int valueBegins = stringToParse.indexOf(62, n + startTag.length()) + 1;
            if (valueBegins < 0) {
                throw new IOException("Unfinished start tag of element type " + elementName);
            }
            int valueEnds = stringToParse.indexOf(endTag, n);
            if (valueEnds >= 0) {
                String value = stringToParse.substring(valueBegins, valueEnds);
                values.add(value);
                continue;
            }
            throw new IOException("Did not find end tag of element " + elementName);
        }
        return values.toArray(new String[values.size()]);
    }

    public LogFileHeader getHeader() {
        return this.headerData;
    }

    class LogFileHeaderImpl
    implements LogFileHeader {
        private HashMap<MRI, String> attributeToIds;
        private HashMap<String, MRI> idsToAttributes;
        private HashMap<String, Class<?>> idsToStorageClasses;
        private Long firstTimestamp;
        private final String headerString;

        public LogFileHeaderImpl(String header) {
            this.headerString = header;
            if (this.headerString == null) {
                this.firstTimestamp = -1L;
                this.attributeToIds = new HashMap();
                this.idsToAttributes = new HashMap();
                this.idsToStorageClasses = new HashMap();
            }
        }

        private HashMap<String, Class<?>> getIdsToStorageClasses() {
            return this.idsToStorageClasses;
        }

        @Override
        public long getFirstTimestamp() {
            if (this.firstTimestamp == null) {
                this.firstTimestamp = this.parseFirstTimestamp(this.headerString);
            }
            return this.firstTimestamp;
        }

        @Override
        public Set<MRI> getAttributesInFile() {
            this.ensureAttributesParsed();
            return this.attributeToIds.keySet();
        }

        private HashMap<String, MRI> getIdsToAttributes() {
            this.ensureAttributesParsed();
            return this.idsToAttributes;
        }

        private void ensureAttributesParsed() {
            if (this.idsToAttributes == null) {
                this.attributeToIds = new HashMap();
                this.idsToAttributes = new HashMap();
                this.idsToStorageClasses = new HashMap();
                try {
                    this.parseAttributeNameToIdMappings(this.headerString, this);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private long parseFirstTimestamp(String header) {
            int n = header.indexOf("firstTimestamp");
            if (n > 0) {
                n = header.indexOf(62, n + 1);
                int n2 = header.indexOf(60, n + 1);
                if (n > 0 && n2 > 0) {
                    try {
                        return Long.parseLong(header.substring(n + 1, n2));
                    }
                    catch (NumberFormatException e) {
                        return -1L;
                    }
                }
            }
            return -1L;
        }

        private void parseAttributeNameToIdMappings(String header, LogFileHeaderImpl headerData) throws IOException {
            String[] mappings;
            String[] stringArray = mappings = LogFileReader.this.parseXmlTagValues("attributeToIdMapping", header);
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                String mapping = stringArray[n2];
                String[] qualifiedName = LogFileReader.this.parseXmlTagValues("attributeName", mapping);
                String[] attributeId = LogFileReader.this.parseXmlTagValues("attributeId", mapping);
                String[] attributeType = LogFileReader.this.parseXmlTagValues("attributeType", mapping);
                if (qualifiedName.length != 1 || attributeId.length != 1 || attributeType.length != 1) {
                    throw new IOException("Encountered a faulty attribute name to id mapping: " + mapping);
                }
                MRI descriptor = MRI.createFromQualifiedName(qualifiedName[0].trim());
                String id = new Integer(attributeId[0]).toString();
                Class<?> c = this.getPrimitiveNamesToNumberClasses().get(attributeType[0].trim());
                if (c == null) {
                    c = this.loadWhiteListedClass(attributeType);
                }
                if (c != null && Number.class.isAssignableFrom(c)) {
                    headerData.attributeToIds.put(descriptor, id);
                    headerData.idsToAttributes.put(id, descriptor);
                    headerData.idsToStorageClasses.put(id, c);
                }
                ++n2;
            }
        }

        public Class<?> loadWhiteListedClass(String[] attributeType) {
            try {
                String className = attributeType[0].trim();
                return DefaultRJMXClassFactory.getDefault().forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private HashMap<String, Class<?>> getPrimitiveNamesToNumberClasses() {
            return primitiveNamesToNumberClasses;
        }
    }
}

